/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.rules;

import com.xebialabs.deployit.deployment.rules.Rule;
import com.xebialabs.deployit.deployment.rules.Scope;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;

public class ScriptRule
extends Rule {
    private String script;

    public ScriptRule(String name, Scope scope) {
        super(name, scope);
    }

    @Override
    public void fire(Object scopedObject, DeploymentPlanningContext context) {
        ScriptEngineManager engineManager = new ScriptEngineManager();
        ScriptEngine jythonEngine = engineManager.getEngineByName("python");
        if (jythonEngine == null) {
            throw new IllegalStateException("Could not find the JythonEngine, is it on the classpath?");
        }
        try {
            ScriptContext scriptContext = this.buildContext(scopedObject, context);
            jythonEngine.eval(this.script, scriptContext);
        }
        catch (ScriptException e) {
            throw new IllegalStateException("Script failed", e);
        }
    }

    private ScriptContext buildContext(Object scopedObject, DeploymentPlanningContext context) {
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        if (this.scope == Scope.DEPLOYED) {
            scriptContext.setAttribute("delta", scopedObject, 100);
            scriptContext.setAttribute("deployed", this.getDeployed((Delta)scopedObject), 100);
        } else if (this.scope == Scope.PLAN) {
            scriptContext.setAttribute("deltas", scopedObject, 100);
        } else if (this.scope == Scope.PRE_PLAN || this.scope == Scope.POST_PLAN) {
            scriptContext.setAttribute("specification", scopedObject, 100);
        }
        scriptContext.setAttribute("deployedApplication", context.getDeployedApplication(), 100);
        scriptContext.setAttribute("repository", context.getRepository(), 100);
        scriptContext.setAttribute("context", context, 100);
        return scriptContext;
    }

    private Deployed getDeployed(Delta delta) {
        if (delta.getOperation() == Operation.DESTROY) {
            return delta.getPrevious();
        }
        return delta.getDeployed();
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }
}

