package com.xebialabs.deployit.deployment.rules;

import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;

public abstract class Rule {
    protected final String name;

    protected final Scope scope;

    protected boolean enabled;

    public Rule(String name, Scope scope) {
        this.name = name;
        this.scope = scope;
        this.enabled = true;
    }

    public final String getName() {
        return name;
    }

    public final Scope getScope() {
        return scope;
    }

    public final boolean isEnabled() {
        return enabled;
    }

    public final void disable() {
        enabled = false;
    }

    @Override
    public final String toString() {
        return name;
    }

    /**
     * Fire this rule for a scoped object. The scopedObject depends on the Scope and is one of the following:
     * <p/>
     * <ul><li>For scope = 'deployed' it is a udm.Deployed</li>
     * <li>For scope = 'plan' it is a Deltas object</li>
     * <li>For scope = 'pre-plan' or scope = 'post-plan' it is a DeltaSpecification object</li></ul>
     *
     * @param scopedObject
     * @param context
     */
    public abstract void fire(Object scopedObject, DeploymentPlanningContext context);


}
