package com.xebialabs.deployit.deployment.rules;

import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;

public abstract class OldRule<D> {
    protected String name;

    protected boolean enabled;

    public OldRule(String name, boolean enabled) {
        this.name = name;
        this.enabled = enabled;
    }

    public final String getName() {
        return name;
    }

    public final boolean isEnabled() {
        return enabled;
    }

    public final void disable() {
        enabled = false;
    }


    public abstract boolean canFire(D d, DeploymentPlanningContext context);

    public abstract void fire(D d, DeploymentPlanningContext context);

}
