package com.xebialabs.deployit.deployment.orchestrator;

import java.util.Collection;
import com.google.common.base.Function;

import com.xebialabs.deployit.engine.spi.orchestration.Orchestration;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.deployit.engine.spi.orchestration.Orchestrations.interleaved;

public class ContainerOrchestratorBase {

    protected final Function<Delta, Container> deltaToContainer = new Function<Delta, Container>() {
        public Container apply(Delta input) {
            return getDeployed(input).getContainer();
        }
    };
    protected final Function<Collection<Delta>, Orchestration> deltasToPlan = new Function<Collection<Delta>, Orchestration>() {
        public Orchestration apply(Collection<Delta> input) {
            return interleaved(newArrayList(input));
        }
    };

    protected Deployed<?, ?> getDeployed(Delta input) {
        return input.getDeployed() != null ? input.getDeployed() : input.getPrevious();
    }

}
