package com.xebialabs.deployit.deployment.orchestrator;

import com.xebialabs.deployit.engine.spi.orchestration.Orchestration;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrator;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;

import java.util.ArrayList;
import java.util.List;

import static com.google.common.collect.Iterables.transform;
import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Multimaps.index;
import static com.xebialabs.deployit.engine.spi.orchestration.Orchestrations.parallel;
import static com.xebialabs.deployit.engine.spi.orchestration.Orchestrations.serial;

@Orchestrator.Metadata(name = "container-by-container-serial")
public class ContainerByContainerOrchestrator extends ContainerOrchestratorBase implements Orchestrator {
    @Override
    public Orchestration orchestrate(DeltaSpecification specification) {
        List<Delta> deltas = specification.getDeltas();

        ArrayList<Orchestration> orchestrations = newArrayList(transform(index(deltas, deltaToContainer).asMap().values(), deltasToPlan));
        if(specification.getDeployedApplication().isParallelByContainer()){
            return parallel(orchestrations);
        } else {
            return serial(orchestrations);
        }
    }
}
