/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.orchestrator.OrchestratorRegistry;
import com.xebialabs.deployit.deployment.planner.DefaultDeploymentPlanningContext;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.deployment.planner.Planner;
import com.xebialabs.deployit.deployment.planner.StepAdapter;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.engine.spi.orchestration.InterleavedOrchestration;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestration;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrator;
import com.xebialabs.deployit.engine.spi.orchestration.ParallelOrchestration;
import com.xebialabs.deployit.engine.spi.orchestration.SerialOrchestration;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DeploymentPlanner
implements Planner {
    private Set<Method> contributors;
    private ListMultimap<Operation, Method> typeContributors;
    private List<Method> preProcessors;
    private List<Method> postProcessors;
    private Repository repository;

    private DeploymentPlanner() {
    }

    @Override
    public Plan plan(DeltaSpecification spec) {
        Orchestration orchestration = this.orchestrate(spec);
        Plan plan = new Plan();
        plan.getStepsWithDelta().addAll(this.preProcessPlan(spec).getOrderedSteps());
        plan.getStepsWithDelta().addAll(this.resolvePlan(orchestration, spec, plan));
        plan.getStepsWithDelta().addAll(this.postProcessPlan(spec).getOrderedSteps());
        return plan;
    }

    private StepPlan postProcessPlan(DeltaSpecification spec) {
        return this.processPlan(spec, this.postProcessors);
    }

    private StepPlan preProcessPlan(DeltaSpecification spec) {
        return this.processPlan(spec, this.preProcessors);
    }

    private StepPlan processPlan(DeltaSpecification spec, List<Method> processors) {
        StepPlan steps = new StepPlan();
        for (Method processor : processors) {
            try {
                Object o = processor.getDeclaringClass().newInstance();
                this.addResultingStepToCollector(processor.invoke(o, spec), steps, processor);
            }
            catch (InstantiationException e) {
                throw new PlannerException(e);
            }
            catch (IllegalAccessException e) {
                throw new PlannerException(e);
            }
            catch (InvocationTargetException e) {
                throw this.handleInvocationTargetException(e);
            }
        }
        return steps;
    }

    private List<Plan.StepWithDelta> resolvePlan(Orchestration orchestration, DeltaSpecification spec, Plan plan) {
        if (orchestration instanceof ParallelOrchestration) {
            return this.resolveParallelPlan((ParallelOrchestration)orchestration, spec, plan);
        }
        if (orchestration instanceof SerialOrchestration) {
            return this.resolveSerialPlan((SerialOrchestration)orchestration, spec, plan);
        }
        StepPlan steps = new StepPlan();
        this.orderedResolution((InterleavedOrchestration)orchestration, steps, spec, plan);
        return steps.getOrderedSteps();
    }

    private List<Plan.StepWithDelta> resolveSerialPlan(SerialOrchestration orchestration, DeltaSpecification spec, Plan plan) {
        return this.resolvePlans(orchestration.getPlans(), spec, plan);
    }

    private List<Plan.StepWithDelta> resolveParallelPlan(ParallelOrchestration orchestration, DeltaSpecification spec, Plan plan) {
        return this.resolvePlans(orchestration.getPlans(), spec, plan);
    }

    private List<Plan.StepWithDelta> resolvePlans(List<Orchestration> orchestrations, DeltaSpecification spec, Plan plan) {
        ArrayList resolvedPlans = Lists.newArrayList();
        for (Orchestration subplan : orchestrations) {
            resolvedPlans.addAll(this.resolvePlan(subplan, spec, plan));
        }
        return resolvedPlans;
    }

    private Orchestration orchestrate(DeltaSpecification spec) {
        String orchestratorName = spec.getDeployedApplication().getOrchestrator();
        Orchestrator orchestrator = OrchestratorRegistry.getOrchestrator(orchestratorName);
        Preconditions.checkNotNull((Object)orchestrator, (String)"Could not find a registered orchestrator with name [%s]", (Object[])new Object[]{orchestratorName});
        return orchestrator.orchestrate(spec);
    }

    private void orderedResolution(InterleavedOrchestration orchestration, StepPlan planBuilder, DeltaSpecification spec, Plan plan) {
        DefaultDeploymentPlanningContext context = new DefaultDeploymentPlanningContext(planBuilder, spec.getDeployedApplication(), this.repository, plan);
        this.callTypeContributors(this.typeContributors, orchestration, planBuilder, context);
        this.callContributors(this.contributors, orchestration, context);
    }

    private void callTypeContributors(ListMultimap<Operation, Method> typeContributors, InterleavedOrchestration plan, StepPlan planBuilder, DeploymentPlanningContext context) {
        if (typeContributors == null) {
            return;
        }
        for (Delta dOp : plan.getDeltas()) {
            planBuilder.setDeltaUnderPlanning(dOp);
            List methods = typeContributors.get((Object)dOp.getOperation());
            Deployed<?, ?> deployed = this.getActiveDeployed(dOp);
            for (Method method : methods) {
                Type type = Type.valueOf(method.getDeclaringClass());
                if (type.equals((Object)deployed.getType())) {
                    this.invokeTypeContributer(context, dOp, method);
                    continue;
                }
                Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)deployed.getType());
                if (!descriptor.isAssignableTo(type)) continue;
                this.invokeTypeContributer(context, dOp, method);
            }
        }
    }

    private void callContributors(Set<Method> methods, InterleavedOrchestration plan, DeploymentPlanningContext context) {
        if (methods == null) {
            return;
        }
        Deltas deltas = new Deltas(plan.getDeltas());
        for (Method method : methods) {
            try {
                Object contributorInstance = method.getDeclaringClass().newInstance();
                method.invoke(contributorInstance, deltas, context);
            }
            catch (InstantiationException e) {
                throw new PlannerException(e);
            }
            catch (IllegalAccessException e) {
                throw new PlannerException(e);
            }
            catch (InvocationTargetException e) {
                throw this.handleInvocationTargetException(e);
            }
        }
    }

    private Deployed<?, ?> getActiveDeployed(Delta dOp) {
        if (dOp.getOperation() == Operation.DESTROY) {
            return dOp.getPrevious();
        }
        return dOp.getDeployed();
    }

    private void invokeTypeContributer(DeploymentPlanningContext planContext, Delta delta, Method method) {
        try {
            if (method.getParameterTypes().length == 2) {
                method.invoke(this.getActiveDeployed(delta), planContext, delta);
            } else {
                method.invoke(this.getActiveDeployed(delta), planContext);
            }
        }
        catch (IllegalAccessException e) {
            throw new PlannerException(e);
        }
        catch (InvocationTargetException e) {
            throw this.handleInvocationTargetException(e);
        }
    }

    private PlannerException handleInvocationTargetException(InvocationTargetException e) {
        Throwable cause = e.getCause();
        if (cause != null) {
            return new PlannerException(cause);
        }
        return new PlannerException(e);
    }

    private void addResultingStepToCollector(Object result, StepPlan steps, Method method) {
        if (result == null) {
            return;
        }
        if (result instanceof List) {
            steps.addAll(Collections2.transform((Collection)((List)result), (Function)new Function<Object, Step>(){

                public Step apply(Object input) {
                    return StepAdapter.wrapIfNeeded(input);
                }
            }));
        } else {
            steps.add(StepAdapter.wrapIfNeeded(result));
        }
    }

    public static class PlannerException
    extends RuntimeException {
        public PlannerException() {
        }

        public PlannerException(String message) {
            super(message);
        }

        public PlannerException(String message, Object ... params) {
            super(String.format(message, params));
        }

        public PlannerException(String message, Throwable cause) {
            super(message, cause);
        }

        public PlannerException(Throwable cause) {
            super(cause);
        }
    }

    public static class DeploymentPlannerBuilder {
        private DeploymentPlanner planner = new DeploymentPlanner();

        public DeploymentPlannerBuilder typeContributors(ListMultimap<Operation, Method> typeContributors) {
            this.planner.typeContributors = typeContributors;
            return this;
        }

        public DeploymentPlannerBuilder contributors(Set<Method> contributors) {
            this.planner.contributors = contributors;
            return this;
        }

        public DeploymentPlannerBuilder preProcessors(List<Method> preProcessors) {
            this.planner.preProcessors = preProcessors;
            return this;
        }

        public DeploymentPlannerBuilder postProcessors(List<Method> postProcessors) {
            this.planner.postProcessors = postProcessors;
            return this;
        }

        public DeploymentPlannerBuilder repository(Repository repository) {
            this.planner.repository = repository;
            return this;
        }

        public DeploymentPlanner build() {
            return this.planner;
        }
    }
}

