package com.xebialabs.deployit.deployment.planner;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;

import static com.google.common.collect.Lists.newArrayList;

public class Plan {

    private List<Step> steps = newArrayList();

    private List<Checkpoint> checkpoints = newArrayList();

    private List<ExecutionStateListener> listeners = newArrayList();

    public List<Step> getSteps() {
        return steps;
    }

    public List<Checkpoint> getCheckpoints() {
        return checkpoints;
    }

    public List<ExecutionStateListener> getListeners() {
        return listeners;
    }

    public Writer writePlan(Writer writer) {
        PrintWriter out = new PrintWriter(writer);

        Multimap<Step, Checkpoint> checkpointsByStep = ArrayListMultimap.create();
        for (Checkpoint checkpoint : checkpoints) {
            checkpointsByStep.put(checkpoint.getStep(), checkpoint);
        }

        int index = 0;
        for (Step step : steps) {
            index++;
            out.format("%2s. (%3s) - %s  (%s)\n", index, step.getOrder(), step.getDescription(), step.getClass().getSimpleName());
            if (checkpointsByStep.containsKey(step)) {
                for (Checkpoint checkpoint : checkpointsByStep.get(step)) {
                    out.format("            *checkpoint*  %s\n", checkpoint);
                }
            }
        }

        return writer;
    }

    public static class Checkpoint implements Serializable {
        private Delta delta;
        private Operation operation;
        private Step step;

        public Checkpoint(Delta delta, Step step) {
            this(delta, step, delta.getOperation());
        }

        public Checkpoint(Delta delta, Step step, Operation operation) {
            this.delta = delta;
            this.step = step;
            this.operation = operation;
        }

        public Delta getDelta() {
            return delta;
        }

        public Step getStep() {
            return step;
        }

        public Operation getOperation() {
            return operation;
        }

        @Override
        public String toString() {
            switch (operation) {
            case CREATE:
                return String.format("%s %s", operation, delta.getDeployed());
            case MODIFY:
                return String.format("%s from %s to %s", operation, delta.getPrevious(), delta.getDeployed());
            case DESTROY:
                return String.format("%s %s", operation, delta.getPrevious());
            default:
                return operation.toString();
            }
        }
    }
}
