package com.xebialabs.deployit.engine.tasker.messages

import com.xebialabs.deployit.engine.tasker.{StepId, TaskStep, TaskId, Task}
import com.xebialabs.deployit.engine.api.execution.{StepExecutionState, TaskExecutionState}
import java.util.UUID

case class Start(taskId: TaskId)
case class Enqueue(taskId: TaskId)
case class TaskDone(task: Task)
case class TaskStateEventHandled(taskId: TaskId, oldState: TaskExecutionState, newState: TaskExecutionState)
case class StepStateEventHandled(taskId: TaskId, stepId: StepId, oldState: StepExecutionState, newState: StepExecutionState)
case class Archived(taskId: TaskId)
case class FailedToArchive(taskId: TaskId, exception: Throwable)
case class Cancelled(taskId: TaskId)
case class Registered(taskId: TaskId)

case class Stop(taskId: TaskId)
case class Abort(taskId: TaskId)
