package com.xebialabs.deployit.engine.tasker

import akka.actor.{ActorRef, Actor, ActorLogging, Props}
import com.xebialabs.deployit.engine.tasker.ArchiveActor.messages.SendToArchive
import com.xebialabs.deployit.engine.tasker.messages.{FailedToArchive, Archived}
import scala.util.{Failure, Success, Try}

object ArchiveActor {
  val name = "archive"
  def props(service: Archive) = Props(classOf[ArchiveActor], service)

  object messages {
    case class SendToArchive(task: Task, notificationActor: ActorRef)
  }

}

class ArchiveActor(service: Archive) extends Actor with ActorLogging {

  def receive: Actor.Receive = {
    case SendToArchive(task, notificationActor: ActorRef) =>
      log.info(s"Received [Archive] message with task [${task.getId}].")
      Try(service.archive(task)) match {
        case Success(unit) => notificationActor ! Archived(task.getId)
        case Failure(ex) => notificationActor ! FailedToArchive(task.getId, ex)
      }
    case m@_ => log.error(s"I don't understand message [$m]")
  }
}
