package com.xebialabs.deployit.engine.tasker

import akka.actor.Actor._
import org.slf4j.MDC
import com.xebialabs.deployit.engine.tasker.StepExecutingActor.messages.ExecuteStep
import com.xebialabs.deployit.engine.tasker.TaskManagingActor.messages.{Recovered, Register}
import com.xebialabs.deployit.engine.tasker.ArchiveActor.messages.SendToArchive
import ReceiveWithMdc._

object ReceiveWithMdc {

  val TaskIdAttributeName = "taskId"
  val UsernameAttributeName = "username"
  val StepDescriptionAttributeName = "stepDescription"

  def apply(task: Task)(r: Receive): Receive = new ReceiveWithMdc(Some(task), None, r)
  def apply(taskId: TaskId)(r: Receive): Receive = new ReceiveWithMdc(None, Some(taskId), r)
  def apply()(r: Receive): Receive = new ReceiveWithMdc(None, None, r)
}

class ReceiveWithMdc(task: Option[Task], taskId: Option[TaskId], realReceive: Receive) extends Receive {

  def isDefinedAt(o: Any) = realReceive.isDefinedAt(o)

  def apply(message: Any): Unit = {

    def attributesForTask(task: Task) = Map(TaskIdAttributeName -> task.getId, UsernameAttributeName -> task.getOwner)

    val extraMdc = task.map(attributesForTask).getOrElse(Map()) ++
      taskId.map(taskId => {Map(TaskIdAttributeName -> taskId)}).getOrElse(Map()) ++ {
      message match {
        case ExecuteStep(s, ctx) => Map(StepDescriptionAttributeName -> s.getDescription)
        case Register(t) => attributesForTask(t)
        case Recovered(t) => attributesForTask(t)
        case SendToArchive(t, _) => attributesForTask(t)
        case _ => Map()
      }
    }

    try {
      extraMdc.foreach(kv => MDC.put(kv._1, kv._2))
      realReceive(message)
    } finally {
      extraMdc.keys.foreach(MDC.remove)
    }
  }
}

