/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.packager;

import com.xebialabs.deployit.packager.CiNameCache;
import com.xebialabs.deployit.packager.ManifestWriter;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;

public class ManifestWriterDriver {
    private static final List<String> storedArtifactSchemes = Collections.singletonList("internal:");
    private final CiNameCache cache;
    private ManifestWriter writer;
    private final byte[] byteBuffer = new byte[ArtifactIOUtils.DEFAULT_BUFFER_SIZE()];

    public ManifestWriterDriver(CiNameCache cache, ManifestWriter writer) {
        this.writer = writer;
        this.cache = cache;
    }

    public void writeToPackage(Version version, TFile file) throws IOException {
        this.writeToPackage(version, file, false);
    }

    public void writeToPackage(Version version, TFile file, boolean writeFullAppPath) throws IOException {
        TFile manifestFile = new TFile((File)file, this.writer.getManifestFileName());
        this.write(version, writeFullAppPath);
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.writer.toString().getBytes());
             TFileOutputStream os = new TFileOutputStream((File)manifestFile);){
            ArtifactIOUtils.copyBytes(is, (OutputStream)os, this.byteBuffer);
        }
    }

    void write(Version version) {
        this.write(version, false);
    }

    void write(Version version, boolean writeFullAppPath) {
        this.cache.scan(version);
        this.writeVersion(version, writeFullAppPath);
        this.writer.endManifest();
    }

    private void writeProperties(ConfigurationItem ci, WritePasswords writePasswords, ManifestWriter.ManifestCiWriter ciWriter) {
        for (PropertyDescriptor propertyDescriptor : ci.getType().getDescriptor().getPropertyDescriptors()) {
            if (this.shouldSkipFileUri(propertyDescriptor, ci)) continue;
            this.writeProperty(propertyDescriptor, ci, writePasswords, ciWriter);
        }
    }

    private ManifestWriter.ManifestCiWriter writeVersion(Version version, boolean writeFullAppPath) {
        String appName = writeFullAppPath ? this.applicationNameWithDirectoryPathPreserved(version.getApplication()) : this.cache.lookup((ConfigurationItem)version.getApplication());
        ManifestWriter.ManifestCiWriter manifestCiWriter = this.writer.writeVersion(version.getType(), this.cache.lookup((ConfigurationItem)version), appName);
        WritePasswords exposePasswords = this.shouldWritePasswords(version);
        for (PropertyDescriptor pd : version.getType().getDescriptor().getPropertyDescriptors()) {
            this.writeProperty(pd, (ConfigurationItem)version, exposePasswords, manifestCiWriter);
        }
        return manifestCiWriter;
    }

    private WritePasswords shouldWritePasswords(Version version) {
        boolean exportAllPasswords = (Boolean)version.getProperty("exportAllPasswords");
        boolean exportOnlyPasswordPlaceholders = (Boolean)version.getProperty("exportOnlyPasswordPlaceholders");
        if (exportAllPasswords) {
            return WritePasswords.YES;
        }
        if (exportOnlyPasswordPlaceholders) {
            return WritePasswords.PLACEHOLDERS_ONLY;
        }
        return WritePasswords.NO;
    }

    private String applicationNameWithDirectoryPathPreserved(Application app) {
        if (app.getId().startsWith(Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName())) {
            return app.getId().substring(Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName().length() + 1);
        }
        return app.getId();
    }

    private String filterPasswordValue(String value, WritePasswords writePasswords) {
        if (writePasswords == WritePasswords.YES) {
            return value;
        }
        if (writePasswords == WritePasswords.PLACEHOLDERS_ONLY && value.startsWith("{{") && value.endsWith("}}")) {
            return value;
        }
        return "";
    }

    Type lookupType(ConfigurationItem ci, Class<?> ciClass) {
        if (ci.getType().getTypeSource() != null) {
            return DescriptorRegistry.getDescriptorRegistry((DescriptorRegistryId)ci.getType().getTypeSource()).lookupType(ciClass);
        }
        return Type.valueOf(ciClass);
    }

    private void writeProperty(PropertyDescriptor pd, ConfigurationItem ci, WritePasswords writePasswords, ManifestWriter.ManifestCiWriter manifestCiWriter) {
        Object o = pd.get(ci);
        if (o == null) {
            return;
        }
        if (pd.isHidden()) {
            return;
        }
        manifestCiWriter.property(pd.getName());
        switch (pd.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case STRING: {
                String value = pd.get(ci).toString();
                if (pd.isPassword()) {
                    value = this.filterPasswordValue(value, writePasswords);
                }
                manifestCiWriter.writeAsStringValue(value);
                break;
            }
            case ENUM: {
                manifestCiWriter.writeAsStringValue(pd.get(ci).toString());
                break;
            }
            case DATE: {
                Calendar c = Calendar.getInstance();
                c.setTime((Date)o);
                manifestCiWriter.writeAsStringValue(DatatypeConverter.printDateTime((Calendar)c));
                break;
            }
            case SET_OF_STRING: 
            case LIST_OF_STRING: {
                manifestCiWriter.writeStringCollectionProperty(new ArrayList<String>((Collection)o));
                break;
            }
            case CI: {
                if (pd.isAsContainment()) break;
                manifestCiWriter.writeCiReferenceProperty(this.cache.lookup((ConfigurationItem)o));
                break;
            }
            case SET_OF_CI: 
            case LIST_OF_CI: {
                if (pd.isAsContainment()) {
                    this.writeNestedConfigurationItems((Collection)o, writePasswords);
                    break;
                }
                manifestCiWriter.writeCiReferenceCollectionProperty(((Collection)o).stream().map(this.cache::lookup).collect(Collectors.toList()));
                break;
            }
            case MAP_STRING_STRING: {
                manifestCiWriter.writeMapStringStringProperty((Map)o);
            }
        }
        manifestCiWriter.endProperty();
    }

    private void writeNestedConfigurationItems(Collection<ConfigurationItem> cis, WritePasswords writePasswords) {
        for (ConfigurationItem ci : cis) {
            ManifestWriter.ManifestCiWriter ciWriter = ci instanceof Artifact && this.isLocalArtifact(ci) ? this.writer.writeCi(this.cache.lookup(ci), ci.getType(), CiNameCache.id(this.cache.lookup(ci), ((Artifact)ci).getFile().getName())) : this.writer.writeCi(this.cache.lookup(ci), ci.getType());
            this.writeProperties(ci, writePasswords, ciWriter);
            ciWriter.endCi();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isLocalArtifact(ConfigurationItem ci) {
        if (!ci.getType().instanceOf(this.lookupType(ci, SourceArtifact.class))) {
            return false;
        }
        if (!ci.hasProperty("fileUri")) {
            return true;
        }
        String fileUri = (String)ci.getProperty("fileUri");
        if (fileUri == null) return true;
        if (fileUri.isEmpty()) return true;
        if (!storedArtifactSchemes.stream().anyMatch(fileUri::contains)) return false;
        return true;
    }

    private boolean shouldSkipFileUri(PropertyDescriptor pd, ConfigurationItem ci) {
        return "fileUri".equals(pd.getName()) && this.isLocalArtifact(ci);
    }

    public String toString() {
        return this.writer.toString();
    }

    private static enum WritePasswords {
        YES,
        NO,
        PLACEHOLDERS_ONLY;

    }
}

