/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.packager.io;

import com.typesafe.config.Config;
import com.xebialabs.deployit.util.TryWith$;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils$;
import com.xebialabs.xldeploy.packager.io.DirectoryStreamer;
import com.xebialabs.xldeploy.packager.io.EmptyStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamer;
import com.xebialabs.xldeploy.packager.io.JarArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.JarFileArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.Streamer;
import com.xebialabs.xldeploy.packager.io.StreamerFactory$;
import com.xebialabs.xldeploy.packager.io.SupportedArchiveExtensions$;
import com.xebialabs.xldeploy.packager.io.UnsupportedArchiveExtensionException;
import com.xebialabs.xldeploy.packager.io.ZipArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ZipFileArchiveStreamer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%s!\u0002\u000b\u0016\u0011\u0003\u0001c!\u0002\u0012\u0016\u0011\u0003\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003\u0002\u0003\u0017\u0002\u0005\u0004%\t!A\u0017\t\rY\n\u0001\u0015!\u0003/\u0011\u00159\u0014\u0001\"\u00019\u0011\u001d\t\u0019$\u0001C\u0001\u0003k1AAI\u000b\u0001u!A1h\u0002B\u0001B\u0003%A\b\u0003\u0005K\u000f\t\u0005\t\u0015!\u0003H\u0011!YuA!A!\u0002\u00139\u0005\"\u0002\u0016\b\t\u0003a\u0005B\u0002)\bA\u0013%\u0011\u000b\u0003\u0004_\u000f\u0011\u0005Qc\u0018\u0005\u0006O\u001e!\t\u0001\u001b\u0005\u0007s\u001e\u0001K\u0011\u0002>\t\u000f\u0005Uq\u0001\"\u0001\u0002\u0018!9\u0011\u0011E\u0004\u0005\u0002\u0005\r\u0002bBA\u0011\u000f\u0011\u0005\u0011\u0011\u0006\u0005\t\u0003[9\u0001\u0015\"\u0003\u00020\u0005y1\u000b\u001e:fC6,'OR1di>\u0014\u0018P\u0003\u0002\u0017/\u0005\u0011\u0011n\u001c\u0006\u00031e\t\u0001\u0002]1dW\u0006<WM\u001d\u0006\u00035m\t\u0001\u0002\u001f7eKBdw.\u001f\u0006\u00039u\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003y\t1aY8n\u0007\u0001\u0001\"!I\u0001\u000e\u0003U\u0011qb\u0015;sK\u0006lWM\u001d$bGR|'/_\n\u0003\u0003\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001!\u0003\u0019awnZ4feV\ta\u0006\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005)1\u000f\u001c45U*\t1'\u0001\u0005he&T(\u0010\\3e\u0013\t)\u0004G\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003=!WMZ1vYRl\u0015\r\u001d9j]\u001e\u001cH#A\u001d\u0011\u0005\u0005:1CA\u0004%\u0003=\t'o\u00195jm\u0016l\u0015\r\u001d9j]\u001e\u001c\b\u0003B\u001fE\u000f\u001es!A\u0010\"\u0011\u0005}2S\"\u0001!\u000b\u0005\u0005{\u0012A\u0002\u001fs_>$h(\u0003\u0002DM\u00051\u0001K]3eK\u001aL!!\u0012$\u0003\u00075\u000b\u0007O\u0003\u0002DMA\u0011Q\bS\u0005\u0003\u0013\u001a\u0013aa\u0015;sS:<\u0017a\u0003>ja\u0016s7m\u001c3j]\u001e\f1B[1s\u000b:\u001cw\u000eZ5oOR!\u0011(\u0014(P\u0011\u0015Y4\u00021\u0001=\u0011\u0015Q5\u00021\u0001H\u0011\u0015Y5\u00021\u0001H\u0003]9W\r^!sG\"Lg/Z#oiJL8\u000b\u001e:fC6,'\u000f\u0006\u0002S+B\u0011\u0011eU\u0005\u0003)V\u0011\u0001b\u0015;sK\u0006lWM\u001d\u0005\u0006-2\u0001\raV\u0001\u0005M&dW\r\u0005\u0002Y96\t\u0011L\u0003\u0002\u00175*\t1,\u0001\u0003kCZ\f\u0017BA/Z\u0005\u00111\u0015\u000e\\3\u0002;\u001d,G/\u0011:dQ&4X-\u00128uef\u001cFO]3b[N#(/Z1nKJ$2A\u00151f\u0011\u0015\tW\u00021\u0001c\u0003\tI7\u000f\u0005\u0002YG&\u0011A-\u0017\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0003g\u001b\u0001\u0007q)\u0001\u0003oC6,\u0017AF4fi\u0006\u00138\r[5wK>+H\u000f];u'R\u0014X-Y7\u0015\u0005%<\bC\u00016v\u001b\u0005Y'B\u00017n\u0003%\t'o\u00195jm\u0016\u00148O\u0003\u0002o_\u0006A1m\\7qe\u0016\u001c8O\u0003\u0002qc\u000691m\\7n_:\u001c(B\u0001:t\u0003\u0019\t\u0007/Y2iK*\tA/A\u0002pe\u001eL!A^6\u0003'\u0005\u00138\r[5wK>+H\u000f];u'R\u0014X-Y7\t\u000bat\u0001\u0019A,\u0002\rQ\f'oZ3u\u0003e9W\r\u001e+be\u0006\u00138\r[5wK>+H\u000f];u'R\u0014X-Y7\u0015\u000bm\f\u0019!!\u0002\u0011\u0005q|X\"A?\u000b\u0005y\\\u0017a\u0001;be&\u0019\u0011\u0011A?\u0003-Q\u000b'/\u0011:dQ&4XmT;uaV$8\u000b\u001e:fC6DQ\u0001_\bA\u0002]Cq!a\u0002\u0010\u0001\u0004\tI!\u0001\u0006d_6\u0004(/Z:t_J\u0004r!JA\u0006\u0003\u001f\ty!C\u0002\u0002\u000e\u0019\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007a\u000b\t\"C\u0002\u0002\u0014e\u0013AbT;uaV$8\u000b\u001e:fC6\f1\u0003[1t\u0003J\u001c\u0007.\u001b<f\u000bb$XM\\:j_:$B!!\u0007\u0002 A\u0019Q%a\u0007\n\u0007\u0005uaEA\u0004C_>dW-\u00198\t\u000b\u0019\u0004\u0002\u0019A$\u0002\u0011M$(/Z1nKJ$RAUA\u0013\u0003OAQ!Y\tA\u0002\tDQAZ\tA\u0002\u001d#2AUA\u0016\u0011\u00151&\u00031\u0001X\u000399W\r^!sG\"Lg/\u001a+za\u0016$2aRA\u0019\u0011\u001517\u00031\u0001H\u0003%1wN]\"p]\u001aLw\rF\u0002:\u0003oAq!!\u000f\u0007\u0001\u0004\tY$\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003{\t)%\u0004\u0002\u0002@)!\u0011\u0011HA!\u0015\r\t\u0019%H\u0001\tif\u0004Xm]1gK&!\u0011qIA \u0005\u0019\u0019uN\u001c4jO\u0002")
public class StreamerFactory {
    private final Map<String, String> archiveMappings;
    private final String zipEncoding;
    private final String jarEncoding;

    public static StreamerFactory forConfig(Config config) {
        return StreamerFactory$.MODULE$.forConfig(config);
    }

    public static StreamerFactory defaultMappings() {
        return StreamerFactory$.MODULE$.defaultMappings();
    }

    private Streamer getArchiveEntryStreamer(File file) {
        Streamer streamer;
        String mappedExt = this.getArchiveType(file.getName());
        boolean extOK = BoxesRunTime.unboxToBoolean((Object)TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ArtifactIOUtils$.MODULE$.getResettableInputStream(new FileInputStream(file)), (Function1 & Serializable & scala.Serializable)resettableIs -> BoxesRunTime.boxToBoolean((boolean)SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, file.getName()))).get());
        String string = mappedExt;
        if (!extOK) {
            streamer = new EmptyStreamer();
        } else {
            String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                streamer = new ZipFileArchiveStreamer(file, this.zipEncoding);
            } else {
                String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    streamer = new JarFileArchiveStreamer(file, this.jarEncoding);
                } else {
                    String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> is);
                    } else {
                        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new GzipCompressorInputStream(is));
                        } else {
                            String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new BZip2CompressorInputStream(is));
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
            }
        }
        return streamer;
    }

    public Streamer getArchiveEntryStreamStreamer(InputStream is2, String name) {
        Streamer streamer;
        String mappedExt = this.getArchiveType(name);
        InputStream resettableIs = ArtifactIOUtils$.MODULE$.getResettableInputStream(is2);
        boolean extOK = SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, name);
        String string = mappedExt;
        if (!extOK) {
            streamer = new EmptyStreamer();
        } else {
            String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                streamer = new ZipArchiveStreamStreamer(resettableIs, this.zipEncoding);
            } else {
                String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    streamer = new JarArchiveStreamStreamer(resettableIs, this.jarEncoding);
                } else {
                    String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> is);
                    } else {
                        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new GzipCompressorInputStream(is));
                        } else {
                            String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> new BZip2CompressorInputStream(is));
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
            }
        }
        return streamer;
    }

    public ArchiveOutputStream getArchiveOutputStream(File target) {
        ZipArchiveOutputStream zipArchiveOutputStream;
        String string = this.getArchiveType(target.getName());
        String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            zipArchiveOutputStream = new ZipArchiveOutputStream(target);
        } else {
            String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                zipArchiveOutputStream = new ZipArchiveOutputStream(target);
            } else {
                String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable & scala.Serializable)os -> os);
                } else {
                    String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable & scala.Serializable)os -> new GzipCompressorOutputStream(os));
                    } else {
                        String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable & scala.Serializable)os -> new BZip2CompressorOutputStream(os));
                        } else {
                            String originExt = (String)((Tuple2)this.archiveMappings.find((Function1 & Serializable & scala.Serializable)am -> BoxesRunTime.boxToBoolean((boolean)StreamerFactory.$anonfun$getArchiveOutputStream$4(target, am))).get())._1();
                            throw new UnsupportedArchiveExtensionException(new StringBuilder(59).append(target.getName()).append(" with extension ").append(originExt).append(" -> ").append(string).append(" is not a supported archive output type").toString());
                        }
                    }
                }
            }
        }
        return zipArchiveOutputStream;
    }

    private TarArchiveOutputStream getTarArchiveOutputStream(File target, Function1<OutputStream, OutputStream> compressor) {
        OutputStream wrapped = (OutputStream)compressor.apply((Object)new FileOutputStream(target));
        TarArchiveOutputStream os = new TarArchiveOutputStream(wrapped);
        os.setLongFileMode(3);
        os.setBigNumberMode(2);
        return os;
    }

    public boolean hasArchiveExtension(String name) {
        return this.archiveMappings.exists((Function1 & Serializable & scala.Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString())));
    }

    public Streamer streamer(InputStream is, String name) {
        return this.hasArchiveExtension(name) ? this.getArchiveEntryStreamStreamer(is, name) : new FileStreamStreamer(is, name);
    }

    public Streamer streamer(File file) {
        return file.isDirectory() ? new DirectoryStreamer(file) : (this.hasArchiveExtension(file.getName()) ? this.getArchiveEntryStreamer(file) : new FileStreamer(file));
    }

    private String getArchiveType(String name) {
        Some some;
        Tuple2 tuple2;
        Option option = this.archiveMappings.find((Function1 & Serializable & scala.Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString())));
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedArchiveExtensionException(new StringBuilder(27).append(name).append(" is not a supported archive").toString());
        }
        if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).value()) == null) {
            throw new MatchError((Object)option);
        }
        String originExt = (String)tuple2._1();
        String mappedExt = (String)tuple2._2();
        StreamerFactory$.MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Detected mapped archive extension ").append(originExt).append(" -> ").append(mappedExt).append(" for ").append(name).toString());
        String string = mappedExt;
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$getArchiveOutputStream$4(File target$1, Tuple2 am) {
        return target$1.getName().endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString());
    }

    public StreamerFactory(Map<String, String> archiveMappings, String zipEncoding, String jarEncoding) {
        this.archiveMappings = archiveMappings;
        this.zipEncoding = zipEncoding;
        this.jarEncoding = jarEncoding;
    }
}

