package com.xebialabs.deployit.packager;

import java.util.Collection;
import java.util.Map;

import com.google.common.base.Joiner;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Version;

import static com.google.common.collect.Maps.newHashMap;
import static java.util.EnumSet.of;

class CiNameCache {
    private Map<String,String> idNameCache;

    public CiNameCache() {
        this.idNameCache = newHashMap();
    }

    void scan(Version version) {
        Application application = version.getApplication();
        idNameCache.put(application.getId(), application.getName());
        idNameCache.put(version.getId(), version.getName());
        scan(version, null);
    }

    @SuppressWarnings("unchecked")
    private void scan(ConfigurationItem configurationItem, String base) {
        for (PropertyDescriptor propertyDescriptor : configurationItem.getType().getDescriptor().getPropertyDescriptors()) {
            if (of(PropertyKind.LIST_OF_CI, PropertyKind.SET_OF_CI).contains(propertyDescriptor.getKind()) && propertyDescriptor.isAsContainment()) {
                Collection<ConfigurationItem> cis = (Collection<ConfigurationItem>) propertyDescriptor.get(configurationItem);
                for (ConfigurationItem ci : cis) {
                    String id = id(base, ci);
                    idNameCache.put(ci.getId(), id);
                    scan(ci, id);
                }
            }
        }
    }

    String lookup(ConfigurationItem ci) {
        if (idNameCache.containsKey(ci.getId())) {
            return idNameCache.get(ci.getId());
        }
        return ci.getId();
    }

    private static String id(String baseId, ConfigurationItem ci) {
        String name = ci.getName();
        return id(baseId, name);
    }

    static String id(String baseId, String name) {
        return Joiner.on("/").skipNulls().join(baseId, name);
    }
}
