/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.util

import java.io.{BufferedInputStream, InputStream}

import de.schlichtherle.truezip.file.{TFile, TFileInputStream}
import grizzled.slf4j.Logging

object DetectBOM extends Logging {

  def detect(file: TFile): BOM = {
    debug(s"Reading first bytes of [$file] to detect the BOM")
    TryWith(new BufferedInputStream(new TFileInputStream(file))) { reader =>
      val bom = detect(reader)
      debug(s"BOM [$bom] detected in [$file], using ${Option(bom.getCharset).getOrElse("default")} charset")
      bom
    }.get
  }

  def detect(resettableStream: InputStream): BOM = {

    val bytesRead: Array[Byte] = new Array[Byte](3)
    resettableStream.mark(3)
    resettableStream.read(bytesRead, 0 , 3)
    resettableStream.reset()

    BOM.matchedBOM(bytesRead)
  }
}
