/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.packager.io;

import com.typesafe.config.Config;
import com.xebialabs.deployit.util.TryWith$;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils$;
import com.xebialabs.xldeploy.packager.io.DirectoryStreamer;
import com.xebialabs.xldeploy.packager.io.EmptyStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamer;
import com.xebialabs.xldeploy.packager.io.JarArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.JarFileArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.Streamer;
import com.xebialabs.xldeploy.packager.io.StreamerFactory$;
import com.xebialabs.xldeploy.packager.io.SupportedArchiveExtensions$;
import com.xebialabs.xldeploy.packager.io.UnsupportedArchiveExtensionException;
import com.xebialabs.xldeploy.packager.io.ZipFileArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ZipFileArchiveStreamer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dt!B\u000b\u0017\u0011\u0003\tc!B\u0012\u0017\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003a\u0003\u0002C\u0017\u0002\u0005\u0004%\t!\u0001\u0018\t\r]\n\u0001\u0015!\u00030\u0011\u0015A\u0014\u0001\"\u0001:\u0011\u001d\t\t&\u0001C\u0001\u0003'2Aa\t\f\u0001w!AAh\u0002B\u0001B\u0003%Q\b\u0003\u0005L\u000f\t\u0005\t\u0015!\u0003I\u0011!auA!A!\u0002\u0013A\u0005\"B\u0016\b\t\u0003i\u0005BB)\bA\u0013%!\u000b\u0003\u0004`\u000f\u0011\u0005a\u0003\u0019\u0005\u0006Q\u001e!\t!\u001b\u0005\u0007u\u001e\u0001K\u0011B>\t\u000f\u0005]q\u0001\"\u0001\u0002\u001a!9\u00111E\u0004\u0005\u0002\u0005\u0015\u0002\"CA\u0018\u000fE\u0005I\u0011AA\u0019\u0011\u001d\t\u0019c\u0002C\u0001\u0003\u000fBq!a\u0013\b\t\u0003\ti%A\bTiJ,\u0017-\\3s\r\u0006\u001cGo\u001c:z\u0015\t9\u0002$\u0001\u0002j_*\u0011\u0011DG\u0001\ta\u0006\u001c7.Y4fe*\u00111\u0004H\u0001\tq2$W\r\u001d7ps*\u0011QDH\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aH\u0001\u0004G>l7\u0001\u0001\t\u0003E\u0005i\u0011A\u0006\u0002\u0010'R\u0014X-Y7fe\u001a\u000b7\r^8ssN\u0011\u0011!\n\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\t\u0013A\u00027pO\u001e,'/F\u00010!\t\u0001T'D\u00012\u0015\t\u00114'A\u0003tY\u001a$$NC\u00015\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u001c2\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013a\u00043fM\u0006,H\u000e^'baBLgnZ:\u0015\u0003i\u0002\"AI\u0004\u0014\u0005\u001d)\u0013aD1sG\"Lg/Z'baBLgnZ:\u0011\ty*\u0005\n\u0013\b\u0003\u007f\r\u0003\"\u0001Q\u0014\u000e\u0003\u0005S!A\u0011\u0011\u0002\rq\u0012xn\u001c;?\u0013\t!u%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\r\u001e\u00131!T1q\u0015\t!u\u0005\u0005\u0002?\u0013&\u0011!j\u0012\u0002\u0007'R\u0014\u0018N\\4\u0002\u0017iL\u0007/\u00128d_\u0012LgnZ\u0001\fU\u0006\u0014XI\\2pI&tw\r\u0006\u0003;\u001d>\u0003\u0006\"\u0002\u001f\f\u0001\u0004i\u0004\"B&\f\u0001\u0004A\u0005\"\u0002'\f\u0001\u0004A\u0015aF4fi\u0006\u00138\r[5wK\u0016sGO]=TiJ,\u0017-\\3s)\t\u0019f\u000b\u0005\u0002#)&\u0011QK\u0006\u0002\t'R\u0014X-Y7fe\")q\u000b\u0004a\u00011\u0006!a-\u001b7f!\tIV,D\u0001[\u0015\t92LC\u0001]\u0003\u0011Q\u0017M^1\n\u0005yS&\u0001\u0002$jY\u0016\fQdZ3u\u0003J\u001c\u0007.\u001b<f\u000b:$(/_*ue\u0016\fWn\u0015;sK\u0006lWM\u001d\u000b\u0004'\u00064\u0007\"\u00022\u000e\u0001\u0004\u0019\u0017AA5t!\tIF-\u0003\u0002f5\nY\u0011J\u001c9viN#(/Z1n\u0011\u00159W\u00021\u0001I\u0003\u0011q\u0017-\\3\u0002-\u001d,G/\u0011:dQ&4XmT;uaV$8\u000b\u001e:fC6$\"A\u001b=\u0011\u0005-4X\"\u00017\u000b\u00055t\u0017!C1sG\"Lg/\u001a:t\u0015\ty\u0007/\u0001\u0005d_6\u0004(/Z:t\u0015\t\t(/A\u0004d_6lwN\\:\u000b\u0005M$\u0018AB1qC\u000eDWMC\u0001v\u0003\ry'oZ\u0005\u0003o2\u00141#\u0011:dQ&4XmT;uaV$8\u000b\u001e:fC6DQ!\u001f\bA\u0002a\u000ba\u0001^1sO\u0016$\u0018!G4fiR\u000b'/\u0011:dQ&4XmT;uaV$8\u000b\u001e:fC6$R\u0001`A\u0003\u0003\u000f\u00012!`A\u0001\u001b\u0005q(BA@m\u0003\r!\u0018M]\u0005\u0004\u0003\u0007q(A\u0006+be\u0006\u00138\r[5wK>+H\u000f];u'R\u0014X-Y7\t\u000be|\u0001\u0019\u0001-\t\u000f\u0005%q\u00021\u0001\u0002\f\u0005Q1m\\7qe\u0016\u001c8o\u001c:\u0011\u000f\u0019\ni!!\u0005\u0002\u0012%\u0019\u0011qB\u0014\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA-\u0002\u0014%\u0019\u0011Q\u0003.\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002'!\f7/\u0011:dQ&4X-\u0012=uK:\u001c\u0018n\u001c8\u0015\t\u0005m\u0011\u0011\u0005\t\u0004M\u0005u\u0011bAA\u0010O\t9!i\\8mK\u0006t\u0007\"B4\u0011\u0001\u0004A\u0015\u0001C:ue\u0016\fW.\u001a:\u0015\u000fM\u000b9#!\u000b\u0002,!)!-\u0005a\u0001G\")q-\u0005a\u0001\u0011\"I\u0011QF\t\u0011\u0002\u0003\u0007\u00111D\u0001\nSN\f%o\u00195jm\u0016\f!c\u001d;sK\u0006lWM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0007\u0016\u0005\u00037\t)d\u000b\u0002\u00028A!\u0011\u0011HA\"\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012!C;oG\",7m[3e\u0015\r\t\teJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA#\u0003w\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f)\r\u0019\u0016\u0011\n\u0005\u0006/N\u0001\r\u0001W\u0001\u000fO\u0016$\u0018I]2iSZ,G+\u001f9f)\rA\u0015q\n\u0005\u0006OR\u0001\r\u0001S\u0001\nM>\u00148i\u001c8gS\u001e$2AOA+\u0011\u001d\t9F\u0002a\u0001\u00033\naaY8oM&<\u0007\u0003BA.\u0003Gj!!!\u0018\u000b\t\u0005]\u0013q\f\u0006\u0004\u0003Cr\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\n\t\u0005\u0015\u0014Q\f\u0002\u0007\u0007>tg-[4")
public class StreamerFactory {
    private final Map<String, String> archiveMappings;
    private final String zipEncoding;
    private final String jarEncoding;

    public static StreamerFactory forConfig(Config config) {
        return StreamerFactory$.MODULE$.forConfig(config);
    }

    public static StreamerFactory defaultMappings() {
        return StreamerFactory$.MODULE$.defaultMappings();
    }

    private Streamer getArchiveEntryStreamer(File file) {
        String mappedExt = this.getArchiveType(file.getName());
        boolean extOK = BoxesRunTime.unboxToBoolean((Object)TryWith$.MODULE$.apply((Function0 & Serializable)() -> ArtifactIOUtils$.MODULE$.getResettableInputStream(new FileInputStream(file)), (Function1 & Serializable)resettableIs -> BoxesRunTime.boxToBoolean((boolean)SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, file.getName()))).get());
        String string = mappedExt;
        if (!extOK) {
            return new EmptyStreamer();
        }
        String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new ZipFileArchiveStreamer(file, this.zipEncoding);
        }
        String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return new JarFileArchiveStreamer(file, this.jarEncoding);
        }
        String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> is);
        }
        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new GzipCompressorInputStream(is));
        }
        String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new BZip2CompressorInputStream(is));
        }
        throw new MatchError((Object)string);
    }

    public Streamer getArchiveEntryStreamStreamer(InputStream is2, String name) {
        String mappedExt = this.getArchiveType(name);
        InputStream resettableIs = ArtifactIOUtils$.MODULE$.getResettableInputStream(is2);
        boolean extOK = SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, name);
        String string = mappedExt;
        if (!extOK) {
            return new EmptyStreamer();
        }
        String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new ZipFileArchiveStreamStreamer(resettableIs, this.zipEncoding);
        }
        String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return new JarArchiveStreamStreamer(resettableIs, this.jarEncoding);
        }
        String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> is);
        }
        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new GzipCompressorInputStream(is));
        }
        String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new BZip2CompressorInputStream(is));
        }
        throw new MatchError((Object)string);
    }

    public ArchiveOutputStream getArchiveOutputStream(File target) {
        String string = this.getArchiveType(target.getName());
        String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new ZipArchiveOutputStream(target);
        }
        String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return new ZipArchiveOutputStream(target);
        }
        String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)os -> os);
        }
        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)os -> new GzipCompressorOutputStream(os));
        }
        String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)os -> new BZip2CompressorOutputStream(os));
        }
        String originExt = (String)((Tuple2)this.archiveMappings.find((Function1 & Serializable)am -> BoxesRunTime.boxToBoolean((boolean)StreamerFactory.$anonfun$getArchiveOutputStream$4(target, am))).get())._1();
        throw new UnsupportedArchiveExtensionException(target.getName() + " with extension " + originExt + " -> " + string + " is not a supported archive output type");
    }

    private TarArchiveOutputStream getTarArchiveOutputStream(File target, Function1<OutputStream, OutputStream> compressor) {
        OutputStream wrapped = (OutputStream)compressor.apply((Object)new FileOutputStream(target));
        TarArchiveOutputStream os = new TarArchiveOutputStream(wrapped);
        os.setLongFileMode(3);
        os.setBigNumberMode(2);
        return os;
    }

    public boolean hasArchiveExtension(String name) {
        return this.archiveMappings.exists((Function1 & Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith('.' + (String)am._1())));
    }

    public Streamer streamer(InputStream is, String name, boolean isArchive) {
        if (this.hasArchiveExtension(name)) {
            return this.getArchiveEntryStreamStreamer(is, name);
        }
        if (isArchive) {
            return new ZipFileArchiveStreamStreamer(ArtifactIOUtils$.MODULE$.getResettableInputStream(is), this.zipEncoding);
        }
        return new FileStreamStreamer(is, name);
    }

    public Streamer streamer(File file) {
        if (file.isDirectory()) {
            return new DirectoryStreamer(file);
        }
        if (this.hasArchiveExtension(file.getName())) {
            return this.getArchiveEntryStreamer(file);
        }
        return new FileStreamer(file);
    }

    public boolean streamer$default$3() {
        return false;
    }

    public String getArchiveType(String name) {
        Some some;
        Tuple2 tuple2;
        Option option = this.archiveMappings.find((Function1 & Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith('.' + (String)am._1())));
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedArchiveExtensionException(name + " is not a supported archive");
        }
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String originExt = (String)tuple2._1();
            String mappedExt = (String)tuple2._2();
            StreamerFactory$.MODULE$.logger().debug((Function0 & Serializable)() -> "Detected mapped archive extension " + originExt + " -> " + mappedExt + " for " + name);
            return mappedExt;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$getArchiveOutputStream$4(File target$1, Tuple2 am) {
        return target$1.getName().endsWith('.' + (String)am._1());
    }

    public StreamerFactory(Map<String, String> archiveMappings, String zipEncoding, String jarEncoding) {
        this.archiveMappings = archiveMappings;
        this.zipEncoding = zipEncoding;
        this.jarEncoding = jarEncoding;
    }
}

