/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.packager.placeholders;

import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.util.BOM;
import com.xebialabs.deployit.util.DetectBOM$;
import com.xebialabs.deployit.util.TryWith$;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xldeploy.packager.MustacheScanningReader;
import com.xebialabs.xldeploy.packager.Mustacher;
import com.xebialabs.xldeploy.packager.Mustacher$;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils$;
import com.xebialabs.xldeploy.packager.io.StreamEntry;
import com.xebialabs.xldeploy.packager.io.Streamer;
import com.xebialabs.xldeploy.packager.io.StreamerFactory;
import com.xebialabs.xldeploy.packager.placeholders.DigestOnly$;
import com.xebialabs.xldeploy.packager.placeholders.PlaceholdersUtil$;
import com.xebialabs.xldeploy.packager.placeholders.ProcessArchive$;
import com.xebialabs.xldeploy.packager.placeholders.ProcessTextFile$;
import com.xebialabs.xldeploy.packager.placeholders.ProcessingType;
import com.xebialabs.xldeploy.packager.placeholders.SourceArtifactScanner$;
import com.xebialabs.xldeploy.packager.placeholders.StreamFile;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001du!\u0002\u000b\u0016\u0011\u0003\u0001c!\u0002\u0012\u0016\u0011\u0003\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003\u0002\u0003\u0017\u0002\u0005\u0004%\t!A\u0017\t\rY\n\u0001\u0015!\u0003/\u0011!9\u0014A1A\u0005\u0002\u0005A\u0004BB \u0002A\u0003%\u0011\b\u0003\u0005A\u0003\t\u0007I\u0011A\u0001B\u0011\u0019I\u0015\u0001)A\u0005\u0005\u001a!!%\u0006\u0001K\u0011!Y\u0015B!A!\u0002\u0013a\u0005\"\u0002\u0016\n\t\u0003y\u0005\"\u0002*\n\t\u0003\u0019\u0006\"\u0002>\n\t\u0003Y\b\"CA\u0005\u0013E\u0005I\u0011AA\u0006\u0011!\t\t#\u0003Q\u0005\n\u0005\r\u0002\u0002CA\u001e\u0013\u0001&I!!\u0010\t\u0011\u0005E\u0013\u0002)C\u0005\u0003'B\u0001\"!\u0018\nA\u0013%\u0011q\f\u0005\t\u0003[J\u0001\u0015\"\u0003\u0002p\u0005)2k\\;sG\u0016\f%\u000f^5gC\u000e$8kY1o]\u0016\u0014(B\u0001\f\u0018\u00031\u0001H.Y2fQ>dG-\u001a:t\u0015\tA\u0012$\u0001\u0005qC\u000e\\\u0017mZ3s\u0015\tQ2$\u0001\u0005yY\u0012,\u0007\u000f\\8z\u0015\taR$A\u0005yK\nL\u0017\r\\1cg*\ta$A\u0002d_6\u001c\u0001\u0001\u0005\u0002\"\u00035\tQCA\u000bT_V\u00148-Z!si&4\u0017m\u0019;TG\u0006tg.\u001a:\u0014\u0005\u0005!\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002A\u00051An\\4hKJ,\u0012A\f\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nQa\u001d7gi)T\u0011aM\u0001\tOJL'P\u001f7fI&\u0011Q\u0007\r\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u00059A-\u001a<Ok2dW#A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0005q:\u0012AA5p\u0013\tq4HA\u0004EKZtU\u000f\u001c7\u0002\u0011\u0011,gOT;mY\u0002\nQ\u0002Z3w\u001dVdGn\u0016:ji\u0016\u0014X#\u0001\"\u0011\u0005\r;U\"\u0001#\u000b\u0005q*%\"\u0001$\u0002\t)\fg/Y\u0005\u0003\u0011\u0012\u0013!cT;uaV$8\u000b\u001e:fC6<&/\u001b;fe\u0006qA-\u001a<Ok2dwK]5uKJ\u00043CA\u0005%\u0003=\u0019HO]3b[\u0016\u0014h)Y2u_JL\bC\u0001\u001eN\u0013\tq5HA\bTiJ,\u0017-\\3s\r\u0006\u001cGo\u001c:z)\t\u0001\u0016\u000b\u0005\u0002\"\u0013!)1j\u0003a\u0001\u0019\u0006qQM\u001c:jG\"\f%\u000f^5gC\u000e$H\u0003\u0002+XO>\u0004\"!J+\n\u0005Y3#\u0001B+oSRDQ\u0001\u0017\u0007A\u0002e\u000b!a]1\u0011\u0005i+W\"A.\u000b\u0005qk\u0016\u0001C1si&4\u0017m\u0019;\u000b\u0005y{\u0016aA;e[*\u0011\u0001-Y\u0001\u0004CBL'B\u00012d\u0003\u0019\u0001H.^4j]*\u0011AmG\u0001\tI\u0016\u0004Hn\\=ji&\u0011am\u0017\u0002\u000f'>,(oY3BeRLg-Y2u\u0011\u0015AG\u00021\u0001j\u0003)\u0019HO]3b[\u001aKG.\u001a\t\u0004K)d\u0017BA6'\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011%\\\u0005\u0003]V\u0011!b\u0015;sK\u0006lg)\u001b7f\u0011\u0015\u0001H\u00021\u0001r\u00035iWm]:bO\u0016$\u0015nZ3tiB\u0019QE\u001d;\n\u0005M4#!\u0003$v]\u000e$\u0018n\u001c81!\t)\b0D\u0001w\u0015\t9X)\u0001\u0005tK\u000e,(/\u001b;z\u0013\tIhOA\u0007NKN\u001c\u0018mZ3ES\u001e,7\u000f^\u0001\u0017g\u000e\fg.\u00118e\u0007\u0006d7-\u001e7bi\u0016$\u0015nZ3tiR)A\u000b`?\u007f\u007f\")\u0001,\u0004a\u00013\")\u0001.\u0004a\u0001S\")\u0001/\u0004a\u0001c\"I\u0011\u0011A\u0007\u0011\u0002\u0003\u0007\u00111A\u0001\tSN\u0014Vm]2b]B\u0019Q%!\u0002\n\u0007\u0005\u001daEA\u0004C_>dW-\u00198\u0002AM\u001c\u0017M\\!oI\u000e\u000bGnY;mCR,G)[4fgR$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u001bQC!a\u0001\u0002\u0010-\u0012\u0011\u0011\u0003\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001c\u0019\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty\"!\u0006\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0010dC2\u001cW\u000f\\1uKBc\u0017mY3i_2$WM]:B]\u0012$\u0015nZ3tiRIA+!\n\u0002(\u0005%\u0012Q\u0007\u0005\u00061>\u0001\r!\u0017\u0005\u0006Q>\u0001\r!\u001b\u0005\b\u0003Wy\u0001\u0019AA\u0017\u0003%iWo\u001d;bG\",'\u000f\u0005\u0003\u00020\u0005ER\"A\f\n\u0007\u0005MrCA\u0005NkN$\u0018m\u00195fe\"9\u0011qG\bA\u0002\u0005e\u0012!C8qi\u0012Kw-Z:u!\r)#\u000e^\u0001\u0013g\u000e\fgNR8mI\u0016\u0014\u0018I\u001d;jM\u0006\u001cG\u000fF\u0005U\u0003\u007f\tI%a\u0013\u0002P!9\u0011\u0011\t\tA\u0002\u0005\r\u0013A\u00014b!\rQ\u0016QI\u0005\u0004\u0003\u000fZ&A\u0004$pY\u0012,'/\u0011:uS\u001a\f7\r\u001e\u0005\u0006QB\u0001\r!\u001b\u0005\b\u0003\u001b\u0002\u0002\u0019AA\u001d\u0003\u0019!\u0017nZ3ti\"9\u00111\u0006\tA\u0002\u00055\u0012!G:dC:4\u0015\u000e\\3Pe\u0006\u00138\r[5wK\u0006\u0013H/\u001b4bGR$\u0012\u0002VA+\u0003/\nI&a\u0017\t\u000ba\u000b\u0002\u0019A-\t\u000b!\f\u0002\u0019\u00017\t\u000f\u00055\u0013\u00031\u0001\u0002:!9\u00111F\tA\u0002\u00055\u0012\u0001G;qI\u0006$X\rR5hKN$x+\u001b;i\r&dWM\\1nKR)A+!\u0019\u0002l!9\u00111\r\nA\u0002\u0005\u0015\u0014!B3oiJL\bc\u0001\u001e\u0002h%\u0019\u0011\u0011N\u001e\u0003\u0017M#(/Z1n\u000b:$(/\u001f\u0005\u0007\u0003\u001b\u0012\u0002\u0019\u0001;\u0002\r\u0011|7kY1o)%!\u0016\u0011OA:\u0003k\n9\bC\u0003Y'\u0001\u0007\u0011\fC\u0004\u0002dM\u0001\r!!\u001a\t\u000f\u0005-2\u00031\u0001\u0002.!9\u0011\u0011P\nA\u0002\u0005m\u0014!\u0003;sC:\u001chm\u001c:n!\u001d)\u0013QPAA\u0003\u0003K1!a '\u0005%1UO\\2uS>t\u0017\u0007E\u0002D\u0003\u0007K1!!\"E\u0005-Ie\u000e];u'R\u0014X-Y7")
public class SourceArtifactScanner {
    private final StreamerFactory streamerFactory;

    public void enrichArtifact(SourceArtifact sa, Option<StreamFile> streamFile, Function0<MessageDigest> messageDigest) {
        this.scanAndCalculateDigest(sa, streamFile, messageDigest, this.scanAndCalculateDigest$default$4());
    }

    public void scanAndCalculateDigest(SourceArtifact sa, Option<StreamFile> streamFile, Function0<MessageDigest> messageDigest, boolean isRescan) {
        if (!PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).shouldScanPlaceholders() && PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).hasCheckSum()) {
            SourceArtifactScanner$.MODULE$.logger().info((Function0 & Serializable)() -> "Not enriching " + sa + " as no placeholders should be scanned and checksum is present");
            return;
        }
        None$ digest = PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).shouldGenerateChecksum(isRescan) ? new Some(messageDigest.apply()) : None$.MODULE$;
        Mustacher mustacher = Mustacher$.MODULE$.apply(PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).mustacheDelimiters());
        this.calculatePlaceholdersAndDigest(sa, streamFile, mustacher, (Option<MessageDigest>)digest);
        sa.setPlaceholders(CollectionConverters$.MODULE$.SetHasAsJava(mustacher.placeholders()).asJava());
        digest.foreach((Function1 & Serializable)d -> {
            sa.setProperty("checksum", (Object)Hex.encodeHexString((byte[])d.digest()));
            return BoxedUnit.UNIT;
        });
    }

    public boolean scanAndCalculateDigest$default$4() {
        return false;
    }

    private void calculatePlaceholdersAndDigest(SourceArtifact sa, Option<StreamFile> streamFile, Mustacher mustacher, Option<MessageDigest> optDigest) {
        SourceArtifact sourceArtifact = sa;
        if (sourceArtifact instanceof FolderArtifact) {
            FolderArtifact folderArtifact = (FolderArtifact)sourceArtifact;
            SourceArtifactScanner$.MODULE$.logger().info((Function0 & Serializable)() -> "Going to scan artifact " + folderArtifact + " as a folder artifact");
            this.scanFolderArtifact(folderArtifact, streamFile, optDigest, mustacher);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (streamFile.isEmpty()) {
            SourceArtifactScanner$.MODULE$.logger().info((Function0 & Serializable)() -> "Going to scan artifact " + sa);
            TryWith$.MODULE$.apply((Function0 & Serializable)() -> sa.getFile().getInputStream(), (Function1 & Serializable)fis -> {
                this.scanFileOrArchiveArtifact(sa, new StreamFile(sa.getFile().getName(), fis), (Option<MessageDigest>)optDigest, mustacher);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            SourceArtifactScanner$.MODULE$.logger().info((Function0 & Serializable)() -> "Going to scan artifact " + sa + " from stream");
            this.scanFileOrArchiveArtifact(sa, (StreamFile)streamFile.get(), optDigest, mustacher);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void scanFolderArtifact(FolderArtifact fa, Option<StreamFile> streamFile, Option<MessageDigest> digest, Mustacher mustacher) {
        Streamer streamer;
        Option<StreamFile> option = streamFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            StreamFile x = (StreamFile)some.value();
            streamer = this.streamerFactory.streamer(x.inputStream(), x.name(), this.streamerFactory.streamer$default$3());
        } else if (None$.MODULE$.equals(option)) {
            streamer = this.streamerFactory.streamer(PlaceholdersUtil$.MODULE$.SourceArtifactUtil((SourceArtifact)fa).toLocalFile());
        } else {
            throw new MatchError(option);
        }
        Streamer streamer2 = streamer;
        streamer2.stream().foreach((Function1 & Serializable)entry -> {
            SourceArtifactScanner.$anonfun$scanFolderArtifact$1(this, digest, fa, mustacher, entry);
            return BoxedUnit.UNIT;
        });
    }

    private void scanFileOrArchiveArtifact(SourceArtifact sa, StreamFile streamFile, Option<MessageDigest> digest, Mustacher mustacher) {
        InputStream inputStream = (InputStream)digest.map((Function1 & Serializable)x$2 -> new DigestInputStream(streamFile.inputStream(), (MessageDigest)x$2)).getOrElse((Function0 & Serializable)() -> streamFile.inputStream());
        if (!PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).shouldScanPlaceholders()) {
            SourceArtifactScanner$.MODULE$.logger().debug((Function0 & Serializable)() -> "Artifact [" + sa + "] has disabled placeholder scanning");
        } else {
            this.streamerFactory.streamer(inputStream, streamFile.name(), this.streamerFactory.streamer$default$3()).stream().foreach((Function1 & Serializable)entry -> {
                this.doScan(sa, entry, mustacher, (Function1<InputStream, InputStream>)(Function1 & Serializable)x -> (InputStream)Predef$.MODULE$.identity(x));
                return BoxedUnit.UNIT;
            });
        }
        OverthereUtils.write((InputStream)inputStream, (OutputStream)SourceArtifactScanner$.MODULE$.devNull());
    }

    private void updateDigestWithFilename(StreamEntry entry, MessageDigest digest) {
        ObjectRef digestPath = ObjectRef.create((Object)(entry.getPath() + (entry.isDirectory() ? File.separator : "")));
        digestPath.elem = ((String)digestPath.elem).replace("\\", "/");
        SourceArtifactScanner$.MODULE$.logger().trace((Function0 & Serializable)() -> "scanFolderArtifact: update digest with path [" + (String)digestPath$1.elem + "]");
        digest.update(((String)digestPath.elem).getBytes(StandardCharsets.UTF_8));
    }

    private void doScan(SourceArtifact sa, StreamEntry entry, Mustacher mustacher, Function1<InputStream, InputStream> transform) {
        if (entry.isDirectory()) {
            return;
        }
        TryWith$.MODULE$.apply((Function0 & Serializable)() -> entry.getInputStream(), (Function1 & Serializable)inputStream -> {
            Try try_;
            InputStream is = (InputStream)transform.apply(inputStream);
            ProcessingType processingType = PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).getScanTypeForEntry(entry, $this.streamerFactory);
            if (DigestOnly$.MODULE$.equals(processingType)) {
                SourceArtifactScanner$.MODULE$.logger().debug((Function0 & Serializable)() -> sa + ": Skipping " + entry.getName());
                OverthereUtils.write((InputStream)is, (OutputStream)SourceArtifactScanner$.MODULE$.devNull());
                try_ = BoxedUnit.UNIT;
            } else if (ProcessArchive$.MODULE$.equals(processingType)) {
                SourceArtifactScanner$.MODULE$.logger().debug((Function0 & Serializable)() -> sa + ": Detected archive for " + entry.getName());
                $this.streamerFactory.streamer(is, entry.getName(), $this.streamerFactory.streamer$default$3()).stream().foreach((Function1 & Serializable)e2 -> {
                    this.doScan(sa, e2, mustacher, (Function1<InputStream, InputStream>)(Function1 & Serializable)x -> (InputStream)Predef$.MODULE$.identity(x));
                    return BoxedUnit.UNIT;
                });
                OverthereUtils.write((InputStream)is, (OutputStream)SourceArtifactScanner$.MODULE$.devNull());
                try_ = BoxedUnit.UNIT;
            } else if (ProcessTextFile$.MODULE$.equals(processingType)) {
                InputStreamReader inputStreamReader;
                SourceArtifactScanner$.MODULE$.logger().debug((Function0 & Serializable)() -> sa + ": " + entry.getName() + " is a text file.");
                InputStream resettableInputStream = ArtifactIOUtils$.MODULE$.getResettableInputStream(is);
                BOM bOM = DetectBOM$.MODULE$.detect(resettableInputStream);
                if (((Object)((Object)BOM.NONE)).equals((Object)bOM)) {
                    inputStreamReader = new InputStreamReader(resettableInputStream);
                } else if (bOM != null) {
                    BOM bOM2 = bOM;
                    inputStreamReader = new InputStreamReader(resettableInputStream, bOM2.getCharset());
                } else {
                    throw new MatchError((Object)bOM);
                }
                InputStreamReader reader = inputStreamReader;
                try_ = TryWith$.MODULE$.apply((Function0 & Serializable)() -> mustacher.newReader(reader), (Function1 & Serializable)r -> {
                    SourceArtifactScanner.$anonfun$doScan$9(r);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError((Object)processingType);
            }
            return try_;
        });
    }

    public static final /* synthetic */ void $anonfun$scanFolderArtifact$1(SourceArtifactScanner $this, Option digest$1, FolderArtifact fa$1, Mustacher mustacher$2, StreamEntry entry) {
        digest$1.foreach((Function1 & Serializable)d -> {
            $this.updateDigestWithFilename(entry, d);
            return BoxedUnit.UNIT;
        });
        $this.doScan((SourceArtifact)fa$1, entry, mustacher$2, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> (InputStream)digest$1.map((Function1 & Serializable)x$1 -> new DigestInputStream((InputStream)is, (MessageDigest)x$1)).getOrElse((Function0 & Serializable)() -> is));
    }

    public static final /* synthetic */ void $anonfun$doScan$9(MustacheScanningReader r) {
        OverthereUtils.write((Reader)r, (Writer)SourceArtifactScanner$.MODULE$.devNullWriter());
    }

    public SourceArtifactScanner(StreamerFactory streamerFactory) {
        this.streamerFactory = streamerFactory;
    }
}

