/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.packager;

import com.typesafe.config.ConfigFactory;
import com.xebialabs.deployit.packager.CiNameCache;
import com.xebialabs.deployit.packager.ManifestWriter;
import com.xebialabs.deployit.packager.ManifestWriterDriver;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils;
import com.xebialabs.xldeploy.packager.io.StreamerFactory;
import com.xebialabs.xldeploy.packager.placeholders.SourceArtifactScanner;
import com.xebialabs.xldeploy.packager.placeholders.StreamFile;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Option;

public class DarPackager {
    public static final String PRESCANNED_PLACEHOLDERS_PROPERTYNAME = "preScannedPlaceholders";
    private static final Logger logger = LoggerFactory.getLogger(DarPackager.class);
    private final CiNameCache cache = new CiNameCache();
    private ManifestWriterDriver manifestDriver;
    private Function0<MessageDigest> messageDigest;
    private SourceArtifactScanner scanner;
    private final byte[] byteBuffer = new byte[8192];

    public DarPackager(ManifestWriter writer, Function0<MessageDigest> messageDigest) {
        this.manifestDriver = new ManifestWriterDriver(this.cache, writer);
        this.messageDigest = messageDigest;
        this.scanner = new SourceArtifactScanner(StreamerFactory.forConfig(ConfigFactory.defaultReference()));
    }

    public TFile buildPackage(Version version, String targetDir) {
        return this.buildPackage(version, targetDir, false);
    }

    public TFile buildPackage(Version version, String targetDir, boolean writeFullPaths) {
        if (version instanceof DeploymentPackage) {
            this.enrichArtifactsForDeploymentPackage((DeploymentPackage)version);
        }
        String darName = this.darName(version);
        TFile darPackage = new TFile(targetDir, darName);
        try {
            this.manifestDriver.writeToPackage(version, darPackage, writeFullPaths);
            this.writeArtifactsToPackage((ConfigurationItem)version, darPackage);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        finally {
            try {
                TVFS.umount((TFile)darPackage);
            }
            catch (FsSyncException e) {
                logger.warn("Couldn't cleanly umount the dar package {}", (Object)darPackage);
            }
        }
        return darPackage;
    }

    private void writeArtifactsToPackage(ConfigurationItem ci, TFile darPackage) {
        if (this.manifestDriver.isLocalArtifact(ci)) {
            TFile artifactDir;
            OverthereFile sourceFile;
            if (ci instanceof FolderArtifact) {
                sourceFile = ((Artifact)ci).getFile();
                if (logger.isDebugEnabled()) {
                    logger.debug("Writing {} to package {}", (Object)sourceFile, (Object)darPackage);
                }
                artifactDir = new TFile((File)darPackage, this.cache.lookup(ci), TArchiveDetector.NULL);
                artifactDir.mkdirs();
                if (sourceFile.isFile()) {
                    this.copyFile(sourceFile, new TFile((File)artifactDir, sourceFile.getName(), TArchiveDetector.NULL));
                } else {
                    TFile targetFolder = new TFile((File)artifactDir, sourceFile.getName());
                    targetFolder.mkdirs();
                    this.copyFolder(sourceFile, targetFolder);
                }
            } else if (ci instanceof Artifact) {
                sourceFile = ((Artifact)ci).getFile();
                if (logger.isDebugEnabled()) {
                    logger.debug("Writing {} to package {}", (Object)sourceFile, (Object)darPackage);
                }
                artifactDir = new TFile((File)darPackage, this.cache.lookup(ci), TArchiveDetector.NULL);
                artifactDir.mkdirs();
                TFile targetFile = new TFile((File)artifactDir, sourceFile.getName(), TArchiveDetector.NULL);
                this.copyFile(sourceFile, targetFile);
            }
        }
        for (PropertyDescriptor pd : ci.getType().getDescriptor().getPropertyDescriptors()) {
            if (!pd.isAsContainment() || !EnumSet.of(PropertyKind.LIST_OF_CI, PropertyKind.SET_OF_CI).contains(pd.getKind())) continue;
            Collection cis = (Collection)pd.get(ci);
            if (cis == null) {
                logger.warn("{}: {}.{} (as-containment, kind {}) should not be null", new Object[]{ci.getId(), ci.getType(), pd.getName(), pd.getKind()});
                continue;
            }
            for (ConfigurationItem c : cis) {
                this.writeArtifactsToPackage(c, darPackage);
            }
        }
    }

    private void enrichArtifactsForDeploymentPackage(DeploymentPackage version) {
        version.getDeployables().stream().filter(d -> d instanceof SourceArtifact).forEach(deployable -> {
            SourceArtifact sourceArtifact = (SourceArtifact)deployable;
            if (this.artifactContainsRealFile(sourceArtifact) && !this.isArtifactPreEnriched(sourceArtifact).booleanValue()) {
                if (logger.isInfoEnabled()) {
                    logger.info("Going to enrich artifact: {}", (Object)sourceArtifact);
                }
                this.scanner.enrichArtifact(sourceArtifact, (Option<StreamFile>)Option.empty(), this.messageDigest);
            }
        });
    }

    private Boolean isArtifactPreEnriched(SourceArtifact deployable) {
        Boolean isPreEnrichedArtifact = deployable.getChecksum() != null && !deployable.getChecksum().isEmpty() && deployable.hasProperty(PRESCANNED_PLACEHOLDERS_PROPERTYNAME) && (Boolean)deployable.getProperty(PRESCANNED_PLACEHOLDERS_PROPERTYNAME) != false;
        if (logger.isInfoEnabled()) {
            logger.info("Artifact {} is {} pre-enriched", (Object)deployable, (Object)(isPreEnrichedArtifact != false ? "" : "not"));
        }
        return isPreEnrichedArtifact;
    }

    private boolean artifactContainsRealFile(SourceArtifact sourceArtifact) {
        boolean isFileReal;
        boolean bl = isFileReal = sourceArtifact.getFile() != null;
        if (logger.isInfoEnabled()) {
            logger.info("Artifact: {} is {} containing real file", (Object)sourceArtifact, (Object)(isFileReal ? "" : "not"));
        }
        return isFileReal;
    }

    private void copyFolder(OverthereFile sourceFile, TFile targetFolder) {
        for (OverthereFile overthereFile : sourceFile.listFiles()) {
            if (overthereFile.isFile()) {
                this.copyFile(overthereFile, new TFile((File)targetFolder, overthereFile.getName(), TArchiveDetector.NULL));
                continue;
            }
            if (!overthereFile.isDirectory()) continue;
            TFile targetFolder1 = new TFile((File)targetFolder, overthereFile.getName());
            targetFolder1.mkdirs();
            this.copyFolder(overthereFile, targetFolder1);
        }
    }

    private void copyFile(OverthereFile sourceFile, TFile targetFile) {
        try (InputStream is = sourceFile.getInputStream();
             TFileOutputStream os = new TFileOutputStream((File)targetFile);){
            ArtifactIOUtils.copyBytes(is, (OutputStream)os, this.byteBuffer);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    private String darName(Version version) {
        return String.format("%s-%s.dar", version.getApplication().getName(), version.getVersion());
    }
}

