/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.util

import java.io.Closeable

import grizzled.slf4j.Logging

import scala.util.control.NonFatal
import scala.util.{Failure, Success, Try}

object TryWith extends Logging {

  def apply[C <: Closeable, R](resource: => C)(f: C => R): Try[R] =
    Try(resource) match {
      case Success(resourceInstance) => {
        try {
          val returnValue = f(resourceInstance)
          Try(resourceInstance.close()).map(_ => returnValue)
        } catch {
          case NonFatal(exceptionInFunction) =>
            logger.error(s"Exception occurred: $exceptionInFunction")
            try {
              resourceInstance.close()
              Failure(exceptionInFunction)
            } catch {
              case NonFatal(exceptionInClose) =>
                exceptionInFunction.addSuppressed(exceptionInClose)
                Failure(exceptionInFunction)
            }
        }
      }
      case Failure(cause) => {
        logger.error(s"Exception occurred: $cause")
        Failure(cause)
      }
    }

}
