/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xldeploy.packager.io

import java.io.{BufferedInputStream, InputStream}

import org.apache.commons.compress.archivers.tar.TarArchiveInputStream

import scala.util.{Failure, Success, Try}

object ArtifactIOUtils {
    def getResettableInputStream(is: InputStream): InputStream =
      Try(is.reset()) match {
        case Failure(_) => new BufferedInputStream(is)
        case Success(_) if is.isInstanceOf[TarArchiveInputStream] => new BufferedInputStream(is) // it does not reset correctly
        case _ => is
      }
}
