/**
 * Copyright © 2014-2016 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xldeploy.packager


import com.typesafe.config.{Config, ConfigRenderOptions, ConfigUtil}

import collection.JavaConverters._

class PackagerConfig(config: Config) {

  val archiveExtensionMappings: Map[String, String] =
    config.getConfig("xl.xldeploy.placeholders.archive-extensions")
      .entrySet()
      .asScala
      .foldLeft(Map[String, String]()) {
        case (m, e) => m + (ConfigUtil.splitPath(e.getKey).get(0) -> e.getValue.unwrapped().toString)
      }
}
