/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xldeploy.packager

object Delims {
  sealed trait Match
  case object No extends Match
  case object Partial extends Match
  case object Full extends Match
}

class Delims(delims: String) {
  require((delims.length == 5 && delims(2) == ' ') || (delims.length == 3 && delims(1) == ' '), "Wrong format of delimiters provided, should be '12 34' or '1 2', where 1, 2, 3 and 4 delimiter characters")
  val Array(start, end) = delims.split(' ').map(_.toCharArray)

  def matchesStart(c1: Char): Delims.Match = {
    matches(c1, '\u0000', start)
  }

  def matchesStart(c1: Char, c2: Char): Delims.Match = {
    matches(c1, c2, start)
  }

  def matchesEnd(c1: Char): Delims.Match = {
    matches(c1, '\u0000', end)
  }

  def matchesEnd(c1: Char, c2: Char): Delims.Match = {
    matches(c1, c2, end)
  }

  private[this] def matches(c1: Char, c2: Char, delim: Array[Char]): Delims.Match = {
    if (c1 != delim(0)) {
      Delims.No
    } else if (delim.length == 1) {
      Delims.Full
    } else if (delim.length == 2 && c2 == delim(1)) {
      Delims.Full
    } else {
      Delims.Partial
    }

  }
}
