package com.xebialabs.deployit.booter.local.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

import com.xebialabs.deployit.plugin.api.validation.Validator;

import static java.lang.String.format;

public class ReflectionUtils {

    public static Field searchField(Class<?> clazz, String name) {
        for (Class<?> scan = clazz; !scan.equals(Object.class); scan = scan.getSuperclass()) {
            try {
                return scan.getDeclaredField(name);
            } catch (NoSuchFieldException e) {
                // scan up the tree
            }
        }
        throw new IllegalArgumentException("Cannot find '" + name + "' field on " + clazz.getName());
    }

    public static RuntimeException handleInvocationTargetException(InvocationTargetException e, String msg) {
        Throwable cause = e.getCause();
        if (cause != null) {
            return new RuntimeException(msg + "\n" + cause.getMessage(), cause);
        } else {
            return new RuntimeException(msg, e);
        }
    }

    public static void setField(Object on, String fieldName, Object value) {
        Field field = searchField(on.getClass(), fieldName);
        field.setAccessible(true);
        setField(on, field, value);
    }

    public static Object getField(Object on, Field field) {
        try {
            return field.get(on);
        } catch (IllegalAccessException e) {
            throw new IllegalArgumentException(format("Could not get field %s on %s.", field.getName(), on), e);
        }
    }

    static void setField(Object on, Field field, Object value) {
        try {
            field.set(on, value);
        } catch (IllegalAccessException e) {
            throw new IllegalArgumentException(format("Could not set field %s on %s to value %s.", field.getName(), on, value), e);
        }
    }

    public static void setFieldWithConversion(final Object on, final String fieldName, final String value) {
        Field field = searchField(on.getClass(), fieldName);
        field.setAccessible(true);
        Class<?> type = field.getType();
        try {
            if (type.equals(String.class)) {
                setField(on, field, value);
            } else if (type.equals(int.class) || type.equals(Integer.class)) {
                field.set(on, Integer.parseInt(value));
            } else if (type.equals(boolean.class) || type.equals(Boolean.class)) {
                field.set(on, Boolean.parseBoolean(value));
            } else {
                throw new IllegalArgumentException(format("Cannot yet convert type [%s] for field [%s]", type, field));
            }
        } catch (IllegalAccessException e) {
            throw new IllegalArgumentException(format("Could not set field %s on %s to value %s.", field.getName(), on, value), e);
        }
    }
}
