package com.xebialabs.deployit.booter.local;

import com.google.common.collect.Lists;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

class DeployableGenerator {
    static void init() {
        generateDeployables();
    }

    static void generateDeployables() {
        List<Descriptor> generatedDeployableDescriptors = Lists.newArrayList();
        for (Descriptor d : Lists.newArrayList(LocalDescriptorRegistry.getDescriptors())) {
            LocalDescriptor descriptor = (LocalDescriptor) d;
            if (descriptor.shouldGenerateDeployableType()) {
                Descriptor generated = LocalDescriptor.from(descriptor);
                generatedDeployableDescriptors.add(generated);
                LocalDescriptorRegistry.register(generated);
            }
        }

        for (Descriptor d : generatedDeployableDescriptors) {
            ((LocalDescriptor) d).initHierarchy();
        }
    }


}
