/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class ReflectionUtils {
    public static Field searchField(Class<?> clazz, String name) {
        Class<?> scan = clazz;
        while (!scan.equals(Object.class)) {
            try {
                return scan.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                scan = scan.getSuperclass();
            }
        }
        throw new IllegalArgumentException("Cannot find '" + name + "' field on " + clazz.getName());
    }

    public static RuntimeException handleInvocationTargetException(InvocationTargetException e, String msg) {
        Throwable cause = e.getCause();
        if (cause != null) {
            return new RuntimeException(msg + "\n" + cause.getMessage(), cause);
        }
        return new RuntimeException(msg, e);
    }

    public static void setField(Object on, String fieldName, Object value) {
        Field field = ReflectionUtils.searchField(on.getClass(), fieldName);
        field.setAccessible(true);
        ReflectionUtils.setField(on, field, value);
    }

    public static Object getField(Object on, Field field) {
        try {
            return field.get(on);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Could not get field %s on %s.", field.getName(), on), e);
        }
    }

    static void setField(Object on, Field field, Object value) {
        try {
            field.set(on, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Could not set field %s on %s to value %s.", field.getName(), on, value), e);
        }
    }
}

