package com.xebialabs.xlplatform.synthetic.xml;

import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

import com.xebialabs.xlplatform.synthetic.ValidationRuleSpecification;

public class XmlValidationRuleSpecification extends XmlElement implements ValidationRuleSpecification {

    public XmlValidationRuleSpecification(Element e) {
        super(e);
    }

    @Override
    public String getType() {
        return element.getAttribute("type");
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> properties = new LinkedHashMap<>();
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); i++) {
            Attr attr = (Attr) attributes.item(i);
            String name = attr.getName();
            if (!name.equals("type")) {
                properties.put(name, attr.getValue());
            }
        }
        return properties;
    }
}
