package com.xebialabs.deployit.booter.local;

import java.io.File;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;

public class GlobalContextInitializer {

    private GlobalContextInitializer() {
        // initializer class without public constructor
    }

    public static void init(DescriptorRegistryId registryId) {
        final File defaultFile = GlobalContext.DEFAULTS;
        var globalContext = GlobalContextRegistry.getGlobalContext(registryId);
        globalContext.init(defaultFile);
    }

    static void init(DescriptorRegistryId registryId, File propertiesFile, GlobalContextManager globalContextManager) {
        var globalContext = GlobalContextRegistry.getGlobalContext(registryId);
        if (globalContextManager != null) {
            globalContext.setManager(globalContextManager);
        }
        globalContext.init(propertiesFile);
    }
}
