package com.xebialabs.deployit.booter.local;

import java.util.*;
import java.util.concurrent.locks.ReentrantReadWriteLock;

import com.xebialabs.deployit.plugin.api.reflect.Type;

public class SealedDescriptorHierarchy {
    private Map<Type, Set<Type>> hierarchy = new HashMap<>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public void registerSubType(Type supertype, Type subtype) {
        lock.writeLock().lock();
        try {
            if (!hierarchy.containsKey(supertype)) {
                hierarchy.put(supertype, new LinkedHashSet<>());
            }
            hierarchy.get(supertype).add(subtype);
        } finally {
            lock.writeLock().unlock();
        }
    }

    public Collection<Type> getSubtypes(Type supertype) {
        lock.readLock().lock();
        try {
            Set<Type> types = hierarchy.get(supertype);
            if (types != null) {
                return new ArrayList<>(types);
            } else {
                return Collections.emptyList();
            }
        } finally {
            lock.readLock().unlock();
        }
    }
}
