package com.xebialabs.deployit.booter.local;

import java.util.Objects;

import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import static com.xebialabs.deployit.booter.local.utils.ReflectionUtils.getAllInterfaces;
import static java.util.stream.Collectors.toList;

class ClassBasedTypeDefinition extends TypeDefinition {
    private Class<? extends ConfigurationItem> clazz;

    public ClassBasedTypeDefinition(IDescriptorRegistry registry, Class<? extends ConfigurationItem> ci) {
        super(registry);
        this.type = type(ci);
        this.superType = type(ci.getSuperclass());
        this.interfaces = getAllInterfaces(ci).stream().map(this::type).filter(Objects::nonNull).collect(toList());
        this.clazz = ci;
    }

    @Override
    protected LocalDescriptor createDescriptor() {
        return new ClassBasedLocalDescriptor(this.type, clazz);
    }

    private boolean isClassACi(Class<?> clazz) {
        return clazz != null && ConfigurationItem.class.isAssignableFrom(clazz);
    }

    private Type type(Class<?> clazz) {
        if (isClassACi(clazz)) {
            return descriptorRegistry.lookupType(clazz);
        } else {
            return null;
        }
    }
}
