package com.xebialabs.xlplatform.synthetic.xml;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

import com.xebialabs.xlplatform.synthetic.CreatorSpecification;

public class XmlCreatorSpecification extends XmlElement implements CreatorSpecification {

    public XmlCreatorSpecification(Element element) {
        super(element);
    }

    @Override
    public String getDelegate() {
        return getRequiredStringAttribute(element, "delegate");
    }

    @Override
    public Map<String, String> getAttributes() {
        Map<String, String> map = new HashMap<>();
        NamedNodeMap xmlAttrs = element.getAttributes();
        for (int i = 0; i < xmlAttrs.getLength(); i++) {
            Attr item = (Attr) xmlAttrs.item(i);
            map.put(item.getName(), item.getValue());
        }
        return map;
    }
}
