package com.xebialabs.xlplatform.synthetic.xml;

import java.util.*;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import com.xebialabs.xlplatform.synthetic.InputHintSpecification;
import com.xebialabs.xlplatform.synthetic.PropertySpecification;
import com.xebialabs.xlplatform.synthetic.ValidationRuleSpecification;

import static com.xebialabs.deployit.booter.local.utils.Strings.split;

public class XmlPropertySpecification extends XmlElement implements PropertySpecification {

    public XmlPropertySpecification(Element element) {
        super(element);
    }

    @Override
    public String getName() {
        return getRequiredStringAttribute(element, "name");
    }

    @Override
    public Optional<String> getKind() {
        return getOptionalString(element, "kind");
    }

    @Override
    public Optional<String> getCategory() {
        return getOptionalString(element, "category");
    }

    @Override
    public Optional<String> getLabel() {
        return getOptionalString(element, "label");
    }

    @Override
    public Optional<String> getDescription() {
        return getOptionalString(element, "description");
    }

    @Override
    public Optional<Boolean> getRequired() {
        return getOptionalBoolean(element, "required");
    }

    @Override
    public Optional<Boolean> getPassword() {
        return getOptionalBoolean(element, "password");
    }

    @Override
    public Optional<Boolean> getAsContainment() {
        return getOptionalBoolean(element, "as-containment");
    }

    @Override
    public Optional<Boolean> getNested() {
        return getOptionalBoolean(element, "nested");
    }

    @Override
    public Optional<String> getSize() {
        return getOptionalString(element, "size");
    }

    @Override
    public Optional<String> getDefault() {
        return getOptionalString(element, "default");
    }

    @Override
    public Optional<Boolean> getHidden() {
        return getOptionalBoolean(element, "hidden");
    }

    @Override
    public Optional<Boolean> getInspectionProperty() {
        return getOptionalBoolean(element, "inspectionProperty");
    }

    @Override
    public Set<String> getAliases() {
        return new LinkedHashSet<>(split(getOptionalStringAttribute(element, "aliases", ""), ","));
    }

    @Override
    public Optional<Boolean> getTransient() {
        return getOptionalBoolean(element, "transient");
    }

    @Override
    public Optional<String> getCandidateValuesFilter() {
        return getOptionalString(element, "candidate-values-filter");
    }

    @Override
    public Optional<Boolean> getReadOnly() {
        return getOptionalBoolean(element, "readonly");
    }

    @Override
    public Optional<String> getEnumClass() {
        return getOptionalString(element, "enum-class");
    }

    @Override
    public List<String> getEnumValues() {
        List<String> enumValues = new ArrayList<>();
        final NodeList values = element.getElementsByTagName("enum-values");
        if (values.getLength() == 1) {
            forEach(childByName((Element) values.item(0), "value"::equals), element -> enumValues.add(element.getTextContent()));
        }
        return enumValues;
    }

    @Override
    public Optional<String> getReferencedType() {
        return getOptionalString(element, "referenced-type");
    }

    @Override
    public List<ValidationRuleSpecification> getValidationRules() {
        List<ValidationRuleSpecification> rules = new ArrayList<>();
        forEach(childByName(element, "rule"::equals), e ->
                rules.add(new XmlValidationRuleSpecification(e)));
        return rules;
    }

    @Override
    public List<InputHintSpecification> getInputHints() {
        List<InputHintSpecification> rules = new ArrayList<>();
        forEach(childByName(element, "input-hint"::equals), e ->
                rules.add(new XmlInputHintSpecification(e)));
        return rules;
    }
}
