package com.xebialabs.deployit.booter.local;

import java.util.Collection;
import java.util.Optional;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.TypeIcon;

import static com.xebialabs.deployit.booter.local.utils.Strings.isNotEmpty;

abstract class CiIconResolver {
    private final static String DEFAULT_CI_ICON = "icons/types/udm.ConfigurationItem.svg";

    private static Optional<String> findFirstIcon(Collection<Type> collection) {
        return collection.stream()
                .filter(DescriptorRegistry::exists)
                .map(DescriptorRegistry::getDescriptor)
                .filter(LocalDescriptor.class::isInstance)
                .map(LocalDescriptor.class::cast)
                .filter(LocalDescriptor::isOwnIcon)
                .map(LocalDescriptor::getIcon)
                .findFirst();
    }

    static void resolveIcon(LocalDescriptor descriptor) {
        if (isNotEmpty(descriptor.getIcon())) {
            return;
        }

        TypeIcon icon = descriptor.getClazz().getAnnotation(TypeIcon.class);
        if (icon != null) {
            descriptor.setIcon(icon.value());
        } else {
            String inheritedIcon = findFirstIcon(descriptor.getSuperClasses())
                    .orElseGet(() -> findFirstIcon(descriptor.getInterfaces()).orElse(DEFAULT_CI_ICON));
            descriptor.setIcon(inheritedIcon);
        }
        descriptor.setOwnIcon(icon != null);
    }
}
