package com.xebialabs.deployit.booter.local

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId

import scala.collection.mutable

object TypeDefinitionsRegistry {
  private val registryDefinitions = mutable.Map[DescriptorRegistryId, TypeDefinitions]()

  def register(registryId: DescriptorRegistryId, typeDefinitions: TypeDefinitions): Unit = {
    registryDefinitions.put(registryId, typeDefinitions)
  }

  def get(registryId: DescriptorRegistryId): Option[TypeDefinitions] = {
    registryDefinitions.get(registryId)
  }
}
