package com.xebialabs.deployit.booter.local

import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlplatform.synthetic.xml.SyntheticXmlDocument

import java.io.{File, UnsupportedEncodingException}
import java.net.{URL, URLDecoder}
import java.util.HashMap
import java.util.function.Predicate
import scala.jdk.CollectionConverters._

object TypePluginMappingManager {
  private val PLUGINS = "/" + "plugins" + "/"
  private val map = new HashMap[String, String]

  def getPluginUrl(ciType: String): String = {
    this.map.get(ciType)
  }

  def getPluginUrlFromType(ciType: String): String = {
    val ci = ciType.split("\\.")
    val keysList = this.map.keySet().asScala.toList
    val requiredCiType = keysList.find(str => str.startsWith(ci(0)))
    this.map.get(requiredCiType.getOrElse())
  }

  def loadTypePluginMapping(url: URL, syntheticXml: SyntheticXmlDocument): Unit = {
    if (filterByFolder(PLUGINS).test(new File(decode(url)).toURI.toURL)) {
      syntheticXml.getTypes.asScala.foreach(ciType => {
        this.map.put(ciType.getTypeName.toString, url.toString)
        if (ciType.getDeployedType.isPresent)
          this.map.put(ciType.getDeployedType.get().toString, url.toString)
      })
    }
  }

  def loadTypePluginMapping(ci: Class[_ <: ConfigurationItem], descriptorRegistry: IDescriptorRegistry): Unit = {
    val url = getClassUrl(ci)
    if (url != null) {
      val typeDef = new ClassBasedTypeDefinition(descriptorRegistry, ci)
      this.map.put(typeDef.getType.toString, url.toString)
    }
  }

  private def getClassUrl(ci: Class[_ <: ConfigurationItem]): URL = {
    ci.getResource("/" + ci.getName.replace(".", "/") + ".class")
  }

  private def filterByFolder(s: String): Predicate[URL] = {
    p => decode(p).contains(s)
  }

  private def decode(url: URL): String = {
    var decodedString = ""
    try {
      decodedString = URLDecoder.decode(url.getPath, "UTF-8")
    } catch {
      case _: UnsupportedEncodingException =>
    }
    decodedString
  }
}