/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.synthetic.yaml;

import com.fasterxml.jackson.databind.JsonNode;
import com.xebialabs.xlplatform.synthetic.InputHintSpecification;
import com.xebialabs.xlplatform.synthetic.PropertySpecification;
import com.xebialabs.xlplatform.synthetic.yaml.JsonInputHintSpecification;
import com.xebialabs.xlplatform.synthetic.yaml.JsonSpecification;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class JsonPropertySpecification
extends JsonSpecification
implements PropertySpecification {
    protected String defaultCategory = null;
    protected boolean defaultHidden = false;

    public JsonPropertySpecification(String name, JsonNode node) {
        super(name, node);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<String> getKind() {
        String defaultKind = null;
        if (this.node.has("referenced-type")) {
            defaultKind = "ci";
        }
        return this.getOptionalString("kind", defaultKind);
    }

    @Override
    public Optional<String> getCategory() {
        return this.getOptionalString("category", this.defaultCategory);
    }

    @Override
    public Optional<Boolean> getRequired() {
        return this.getOptionalBoolean("required");
    }

    @Override
    public Optional<Boolean> getPassword() {
        return this.getOptionalBoolean("password");
    }

    @Override
    public Optional<Boolean> getAsContainment() {
        return this.getOptionalBoolean("as-containment");
    }

    @Override
    public Optional<Boolean> getNested() {
        return this.getOptionalBoolean("nested");
    }

    @Override
    public Optional<String> getSize() {
        return this.getOptionalString("size");
    }

    @Override
    public Optional<String> getDefault() {
        if (this.node.isTextual()) {
            return Optional.of(this.node.asText());
        }
        if (this.node.has("default")) {
            JsonNode value = this.node.get("default");
            if (value.isValueNode()) {
                return Optional.of(value.asText());
            }
            if (value.isArray()) {
                return Optional.of(JsonPropertySpecification.toSyntheticListFormat(value));
            }
            if (value.isObject()) {
                return Optional.of(JsonPropertySpecification.toSyntheticMapFormat(value));
            }
        }
        return Optional.empty();
    }

    private static String toSyntheticListFormat(JsonNode value) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (JsonNode item : value) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            builder.append(item.asText());
        }
        return builder.toString();
    }

    private static String toSyntheticMapFormat(JsonNode node) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        Iterator keys = node.fieldNames();
        while (keys.hasNext()) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            String key = (String)keys.next();
            String value = node.get(key).asText();
            builder.append(key).append(":").append(value);
        }
        return builder.toString();
    }

    @Override
    public Optional<Boolean> getHidden() {
        return this.getOptionalBoolean("hidden", this.defaultHidden);
    }

    @Override
    public Optional<Boolean> getInspectionProperty() {
        return this.getOptionalBoolean("inspection-property");
    }

    @Override
    public Set<String> getAliases() {
        return new LinkedHashSet<String>(this.getStringValues("aliases"));
    }

    @Override
    public Optional<Boolean> getTransient() {
        return this.getOptionalBoolean("transient");
    }

    @Override
    public Optional<String> getCandidateValuesFilter() {
        return this.getOptionalString("candidate-values-filter");
    }

    @Override
    public Optional<Boolean> getReadOnly() {
        return this.getOptionalBoolean("readonly");
    }

    @Override
    public Optional<String> getEnumClass() {
        return this.getOptionalString("enum-class");
    }

    @Override
    public List<String> getEnumValues() {
        return this.getStringValues("enum-values");
    }

    @Override
    public Optional<String> getReferencedType() {
        return this.getOptionalString("referenced-type");
    }

    @Override
    public List<InputHintSpecification> getInputHints() {
        if (!this.node.has("input-hint")) {
            return Collections.emptyList();
        }
        JsonInputHintSpecification hint = new JsonInputHintSpecification(this.node.get("input-hint"));
        return Collections.singletonList(hint);
    }
}

