package com.xebialabs.deployit.booter.local;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class CiRoots {

    private final static Set<String> rootsFound = new HashSet<>();

    static void findRoots(TypeDefinitions typeDefinitions) {
        rootsFound.addAll(
                typeDefinitions.getDefinitions().stream()
                .map(typeDefinition -> typeDefinition.getType().getDescriptor().getRootName())
                .filter(root -> !root.isEmpty())
                .collect(Collectors.toSet())
        );
    }

    static public Set<String> all() {
        return Collections.unmodifiableSet(rootsFound);
    }

}
