/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalPropertyDescriptor;
import com.xebialabs.deployit.booter.local.ValidationRuleConverter;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.InputHint;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.LazyConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.synthetic.InputHintSpecification;
import com.xebialabs.xlplatform.synthetic.PropertySpecification;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils;
import java.util.List;
import java.util.Optional;

public class SyntheticLocalPropertyDescriptor
extends LocalPropertyDescriptor {
    public SyntheticLocalPropertyDescriptor(LocalDescriptor descriptor, PropertySpecification property) {
        super(descriptor.getType().getTypeSource());
        String name = property.getName();
        this.setName(name);
        this.setDeclaringDescriptor(descriptor);
        this.initSynthetic(property);
    }

    private void initSynthetic(PropertySpecification property) {
        PropertyKind pk = PropertyKind.valueOf((String)property.getKind().orElse(PropertyKind.STRING.name()).toUpperCase());
        if (pk == PropertyKind.BOOLEAN) {
            this.setPrimitiveKind(pk);
        } else {
            this.setKind(pk);
        }
        this.setCategory(property.getCategory().orElse("Common"));
        this.setLabel(property.getLabel().orElse(Strings.deCamelize(this.getName())));
        this.setDescription(property.getDescription().orElse(this.getLabel()));
        this.setRequired(property.getRequired().orElse(true));
        this.reInitializeRequired();
        this.setPassword(property.getPassword().orElse(false));
        this.setAsContainment(property.getAsContainment().orElse(false));
        this.setNested(property.getNested().orElse(false));
        this.setSize(Property.Size.valueOf((String)property.getSize().orElse(Property.Size.DEFAULT.name()).toUpperCase()));
        String defaultValueAttr = property.getDefault().orElse(null);
        this.setHidden(property.getHidden().orElse(false));
        this.setInspectionProperty(property.getInspectionProperty().orElse(false));
        this.setAliases(property.getAliases());
        this.setTransient(this.isHidden() || property.getTransient().orElse(false) != false);
        this.setCandidateValuesFilter(property.getCandidateValuesFilter().orElse(null));
        this.setReadonly(property.getReadOnly().orElse(false));
        PropertyKind kind = this.getKind();
        String propertyName = "property " + this.getName() + " of kind " + this.getKind();
        if (this.getKind() == PropertyKind.ENUM) {
            Optional<String> enumClassName = property.getEnumClass();
            if (enumClassName.isPresent()) {
                try {
                    Class enumClass = ClassLoaderUtils.classByName((String)enumClassName.get());
                    this.setEnumClass(enumClass);
                    if (!enumClass.isEnum()) {
                        throw new IllegalArgumentException("enum-class supplied for " + propertyName + " is not an enum: " + enumClassName);
                    }
                    List<String> enumValues = property.getEnumValues();
                    this.initEnumValues(enumClass, enumValues);
                }
                catch (ClassNotFoundException exc) {
                    throw new IllegalArgumentException("Unknown enum-class supplied for " + propertyName + ": " + enumClassName, exc);
                }
            } else {
                List<String> enumValues = property.getEnumValues();
                if (enumValues.isEmpty()) {
                    throw new IllegalArgumentException("Could not find 'enum-class' attribute or 'enum-values' element defined on " + propertyName);
                }
                this.setEnumValues(enumValues);
            }
        }
        if (kind == PropertyKind.CI || kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI) {
            Optional<String> referencedType = property.getReferencedType();
            if (referencedType.isEmpty()) {
                throw new IllegalArgumentException("Attribute referenced-type not provided input-hint for " + propertyName);
            }
            this.setReferencedType(this.typeOf(referencedType.get()));
        }
        this.initSyntheticValidationRules(property);
        this.addDefaultValidationRules();
        this.initSyntheticInputHints(property, kind);
        this.registerDefault(defaultValueAttr);
    }

    private IDescriptorRegistry registry() {
        return DescriptorRegistry.getDescriptorRegistry((DescriptorRegistryId)this.getTypeSource());
    }

    private Type typeOf(String referencedType) {
        return this.registry().lookupType(referencedType);
    }

    private void initSyntheticInputHints(PropertySpecification property, PropertyKind propertyKind) {
        for (InputHintSpecification inputHintSpec : property.getInputHints()) {
            InputHint inputHint = new InputHint();
            inputHint.setKind(propertyKind);
            inputHint.setValues(inputHintSpec.getValues());
            inputHintSpec.getValidationRules().forEach(rule -> inputHint.getValidationRules().add(ValidationRuleConverter.makeRule(rule, (LocalPropertyDescriptor)this)));
            inputHint.setPrompt((String)inputHintSpec.getPrompt().orElse(null));
            inputHint.setCopyFromProperty((String)inputHintSpec.getCopyFromProperty().orElse(null));
            inputHint.setRequired(this.isRequired());
            inputHint.setReferencedType((Type)inputHintSpec.getReferencedType().map(tn -> tn.toType(this.registry())).orElse(null));
            inputHint.setMethodRef((String)inputHintSpec.getMethodRef().orElse(null));
            inputHint.setDynamicLookup(inputHintSpec.getDynamicLookup().orElse(true).booleanValue());
            this.setInputHint(inputHint);
        }
    }

    private void initSyntheticValidationRules(PropertySpecification property) {
        property.getValidationRules().forEach(rule -> this.validationRules.add(ValidationRuleConverter.makeRule(rule, (LocalPropertyDescriptor)this)));
    }

    public Object get(ConfigurationItem item) {
        LazyConfigurationItem lazyItem;
        if (item instanceof LazyConfigurationItem && !(lazyItem = (LazyConfigurationItem)item).isInitialized()) {
            lazyItem.initialize();
        }
        return this.getDeclaringDescriptor().getSyntheticPropertyValue(item, this.getName());
    }

    @Override
    public final void set(ConfigurationItem item, Object value) {
        LazyConfigurationItem lazyItem;
        if (item instanceof LazyConfigurationItem && !(lazyItem = (LazyConfigurationItem)item).isInitialized()) {
            lazyItem.initialize();
        }
        super.set(item, value);
    }

    @Override
    protected void doSetValue(ConfigurationItem item, Object value) {
        this.getDeclaringDescriptor().setSyntheticPropertyValue(item, this.getName(), value);
    }
}

