package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.synthetic.GeneratedDeployableSpecification;
import com.xebialabs.xlplatform.synthetic.TypeSpecification;

public class GenerateDeployableTypeDefinition extends SyntheticBasedTypeDefinition {

    public GenerateDeployableTypeDefinition(Type owner, TypeSpecification generatedType) {
        super(DescriptorRegistry.getDescriptorRegistry(owner.getTypeSource()), generatedType);
        this.owner = owner;
    }

    @Override
    protected LocalDescriptor createDescriptor() {
        var ownerDescriptor = (SyntheticLocalDescriptor) DescriptorRegistry.getDescriptor(owner);
        GeneratedDeployableSpecification generatedDeployableSpec = ownerDescriptor.getGeneratedDeployableDescription();
        var generatedDeployableType = generatedDeployableSpec.getType().toType(descriptorRegistry);
        return new GenerateDeployableLocalDescriptor(generatedDeployableType, ownerDescriptor);
    }
}
