package com.xebialabs.deployit.booter.local;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.creator.CreatorContext;
import com.xebialabs.deployit.plugin.api.reflect.CreatorDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.udm.Delegate;

import static com.xebialabs.deployit.booter.local.utils.CheckUtils.checkNotNull;
import static com.xebialabs.deployit.plugin.api.udm.ControlTask.DEFAULT_DELEGATE;

public class LocalCreatorDescriptor implements CreatorDescriptor {

    private String name;
    private String delegate;
    private Map<String, String> attributes = new HashMap<>();
    private Descriptor descriptor;

    private LocalCreatorDescriptor(Descriptor descriptor, String name) {
        this.name = name;
        this.descriptor = descriptor;
    }

    private LocalCreatorDescriptor(Descriptor descriptor, Method method) {
        this.name = method.getName();
        this.delegate = DEFAULT_DELEGATE;
        this.descriptor = descriptor;
    }

    LocalCreatorDescriptor(LocalCreatorDescriptor copyOf, Descriptor newOwner) {
        this.attributes = copyOf.attributes;
        this.delegate = copyOf.delegate;
        this.descriptor = newOwner;
    }

    static CreatorDescriptor from(Descriptor descriptor, Method method) {
        LocalCreatorDescriptor creatorDescriptor = new LocalCreatorDescriptor(descriptor, method);
        initVerifications(creatorDescriptor);
        return creatorDescriptor;
    }

    public static CreatorDescriptor from(LocalDescriptor descriptor, String delegate, Map<String, String> attributes) {
        LocalCreatorDescriptor creatorDescriptor = new LocalCreatorDescriptor(descriptor, delegate);
        creatorDescriptor.delegate = delegate;
        creatorDescriptor.attributes = attributes;
        initVerifications(creatorDescriptor);
        return creatorDescriptor;
    }

    private static void initVerifications(final LocalCreatorDescriptor creatorDescriptor) {
        checkNotNull(DelegateRegistry.getDelegate(creatorDescriptor.delegate, Delegate.Use.CREATOR), creatorDescriptor.delegate + " is referenced, but not registered.");
    }

    void verify(final Verifications verifications) {
        verifications.verify(descriptor.getType(), DelegateRegistry.exists(delegate, Delegate.Use.CREATOR), "No delegate called [%s] available for creator [%s]", delegate, getFqn());
    }

    Descriptor getDescriptor() {
        return descriptor;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public Map<String, String> getAttributes() {
        return attributes;
    }

    @Override
    public void invoke(CreatorContext context) {
        this.invokeDelegate(context);
    }

    @SuppressWarnings("unchecked")
    private void invokeDelegate(CreatorContext context) {
        Method method = DelegateRegistry.getDelegate(delegate, Delegate.Use.CREATOR);
        try {
            if (method.getParameterCount() == 2) {
                method.invoke(null, context, attributes);
            } else {
                method.invoke(null, context);
            }
        } catch (IllegalAccessException e) {
            throw new RuntimeException("Could not invoke " + delegate + " on " + context.getThisCI());
        } catch (InvocationTargetException e) {
            throw ReflectionUtils.handleInvocationTargetException(e, "Could not invoke " + delegate + " on " + context.getThisCI());
        }
    }

    @Override
    public String getFqn() {
        return String.format("%s.%s", descriptor.getType(), name);
    }

}
