package com.xebialabs.deployit.booter.local.utils;

import static java.lang.String.format;

public class CheckUtils {

    public static void checkArgument(boolean expression, String errorMessage, Object... messageParams) {
        if (!expression) {
            throw new IllegalArgumentException(format(errorMessage, messageParams));
        }
    }

    public static void checkState(boolean expression, String errorMessage, Object... messageParams) {
        if (!expression) {
            throw new IllegalStateException(format(errorMessage, messageParams));
        }
    }

    public static <T> T checkNotNull(T t, String errorMessage, Object... messageParams) {
        if (t == null) {
            throw new NullPointerException(format(errorMessage, messageParams));
        }
        return t;
    }

}
