package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

public class LocalPropertyDescriptorWithDifferentOwner extends LocalPropertyDescriptor {

    private final LocalPropertyDescriptor superPropertyDescriptor;

    public LocalPropertyDescriptorWithDifferentOwner(LocalPropertyDescriptor pd, LocalDescriptor newOwner) {
        super(newOwner.getType().getTypeSource()); // TODO S-92848 check if this is correct type source
        this.superPropertyDescriptor = pd;
        this.setDeclaringDescriptor(newOwner);
        setFromPropertyDescriptor(pd);
        registerDefault(pd);
    }

    @Override
    public Object get(ConfigurationItem item) {
        return superPropertyDescriptor.get(item);
    }

    @Override
    protected void doSetValue(ConfigurationItem item, Object value) {
        superPropertyDescriptor.set(item, value);
    }

    public LocalPropertyDescriptor getSuperPropertyDescriptor() {
        return superPropertyDescriptor;
    }
}
