package com.xebialabs.xlplatform.synthetic.yaml;

import java.util.Collections;
import java.util.Map;
import com.fasterxml.jackson.databind.JsonNode;

import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.xlplatform.synthetic.ValidationRuleSpecification;

public class JsonValidationRuleSpecification extends JsonSpecification implements ValidationRuleSpecification {

    private static final String TYPE_FIELD = "type";

    public JsonValidationRuleSpecification(IDescriptorRegistry descriptorRegistry, JsonNode node) {
        super(descriptorRegistry, "rule", node);
    }

    @Override
    public String getType() {
        if (node.has(TYPE_FIELD)) {
            return node.get(TYPE_FIELD).asText();
        }
        return "regex";
    }

    @Override
    public Map<String, String> getProperties() {
        return toMap(Collections.singleton(TYPE_FIELD));
    }
}
