package com.xebialabs.xlplatform.synthetic.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;

import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.synthetic.BaseTypeSpecification;
import com.xebialabs.xlplatform.synthetic.MethodSpecification;
import com.xebialabs.xlplatform.synthetic.PropertySpecification;
import com.xebialabs.xlplatform.synthetic.ValidationRuleSpecification;

public class XmlBaseTypeSpecification extends XmlElement implements BaseTypeSpecification {

    public XmlBaseTypeSpecification(IDescriptorRegistry descriptorRegistry, Element element) {
        super(descriptorRegistry, element);
    }

    @Override
    public Type getType() {
        return getRequiredTypeAttribute(element, "type");
    }

    @Override
    public Optional<Boolean> getVirtual() {
        return getOptionalBoolean(element, "virtual");
    }

    @Override
    public List<PropertySpecification> getProperties() {
        List<PropertySpecification> properties = new ArrayList<>();
        forEach(childByName(element, "property"::equals), child -> {
            getRequiredStringAttribute(child, "name");
            properties.add(new XmlPropertySpecification(descriptorRegistry, child));
        });
        return properties;
    }

    @Override
    public List<MethodSpecification> getMethods() {
        List<MethodSpecification> methods = new ArrayList<>();
        childByName(element, "method"::equals).forEachRemaining(
                method -> methods.add(new XmlMethodSpecification(descriptorRegistry, method)));

        return methods;
    }

    @Override
    public Optional<Boolean> getVersioned() {
        return getOptionalBoolean(element, "versioned");
    }

    @Override
    public List<ValidationRuleSpecification> getValidationRules() {
        List<ValidationRuleSpecification> validators = new ArrayList<>();
        forEach(childByName(element, "rule"::equals),
                element -> validators.add(new XmlValidationRuleSpecification(descriptorRegistry, element)));
        return validators;
    }

    @Override
    public List<String> getVerifications() {
        List<String> verifications = new ArrayList<>();
        forEach(childByName(element, "verification"::equals),
                element -> verifications.add(element.getAttribute("type")));
        return verifications;
    }

    @Override
    public List<MethodSpecification> getControlTasks() {
        List<MethodSpecification> methods = new ArrayList<>();
        forEach(childByName(element, "method"::equals), child ->
                methods.add(new XmlMethodSpecification(descriptorRegistry, child))
        );
        return methods;
    }
}
