package com.xebialabs.deployit.booter.local;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.synthetic.TypeModificationSpecification;

public abstract class TypeDefinition {

    protected Type type;
    protected Type superType;
    protected Deque<TypeModificationSpecification> typeModifications = new ArrayDeque<>();
    protected List<Type> interfaces = new ArrayList<>();
    protected Type owner;

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return type;
    }

    public Type getSuperType() {
        return superType;
    }

    public void setSuperType(Type superType) {
        this.superType = superType;
    }

    public List<Type> getInterfaces() {
        return interfaces;
    }

    public Type getOwner() {
        return owner;
    }

    public void addTypeModification(TypeModificationSpecification specification) {
        typeModifications.push(specification);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + type + "]";
    }

    protected abstract LocalDescriptor createDescriptor();

    void applyTypeModifications(LocalDescriptor descriptor) {
        typeModifications.forEach(descriptor::applyTypeModification);
    }
}
