package com.xebialabs.deployit.booter.local

import com.xebialabs.deployit.plugin.api.reflect.{BaseDescriptorRegistry, Descriptor, Type}

import java.util
import java.util.Collections
import java.util.concurrent.ConcurrentHashMap

class ReloadableDescriptorRegistry(registryId: ReloadableDescriptorRegistryId) extends BaseDescriptorRegistry(registryId) {

  private val subtypes = new SealedDescriptorHierarchy()
  private val descriptors: util.Map[Type, Descriptor] = new ConcurrentHashMap[Type, Descriptor]()

  private lazy val _descriptors = Collections.unmodifiableCollection(descriptors.values())

  // we cannot add 2nd local registry
  override def isLocal: Boolean = false

  override def isDefault: Boolean = true

  override def _getDescriptors(): util.Collection[Descriptor] = _descriptors // once requested it's frozen

  override def _getSubtypes(supertype: Type): util.Collection[Type] = Collections.unmodifiableCollection(subtypes.getSubtypes(supertype))

  override def _getDescriptor(`type`: Type): Descriptor = descriptors.get(`type`)

  override def _exists(`type`: Type): Boolean = descriptors.containsKey(`type`)

  override def register(descriptor: Descriptor): Unit = {

    descriptors.put(descriptor.getType, descriptor)
  }

  override def registerSubtype(supertype: Type, subtype: Type): Unit = {
    //    Checks
    subtypes.registerSubType(supertype, subtype)
  }
}
