package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.xlplatform.synthetic.GeneratedDeployableSpecification;

import static com.xebialabs.deployit.booter.local.DescriptorVerification.PLACEHOLDERS_FIELD;

public class GenerateDeployableLocalDescriptor extends LocalDescriptor {

    private SyntheticLocalDescriptor deployedDescriptor;

    public GenerateDeployableLocalDescriptor(SyntheticLocalDescriptor deployedDescriptor) {
        this.deployedDescriptor = deployedDescriptor;
        GeneratedDeployableSpecification generatedDeployableSpec = deployedDescriptor.getGeneratedDeployableDescription();
        setType(generatedDeployableSpec.getType());
        addSuperClass(generatedDeployableSpec.getSuperType());
        initDescription(generatedDeployableSpec, deployedDescriptor.getDescription());
        setVirtual(generatedDeployableSpec.isVirtual());
        initProperties(deployedDescriptor, generatedDeployableSpec.isInheritDefaultValues());
        initHierarchy();
        resolveIcon();
    }

    private void initDescription(GeneratedDeployableSpecification generatedDeployableSpec, String deployedDescription) {
        String description = generatedDeployableSpec.getDescription();
        if (description == null || description.equals("Description unavailable")) {
            setDescription(deployedDescription + " (deployable)");
        } else {
            setDescription(description);
        }

    }

    private void initProperties(Descriptor descriptor, boolean withDefaults) {
        for (PropertyDescriptor deployedPropertyDescriptor : descriptor.getPropertyDescriptors()) {
            final PropertyKind kind = deployedPropertyDescriptor.getKind();
            boolean isReferenceField = kind == PropertyKind.CI || kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI;
            if (deployedPropertyDescriptor.isDeployedSpecific() ||
                    isReferenceField ||
                    deployedPropertyDescriptor.isHidden() ||
                    PLACEHOLDERS_FIELD.equals(deployedPropertyDescriptor.getName())) {
                continue;
            }

            LocalPropertyDescriptor generatedDeployablePropertyDescriptor = new GeneratedDeployablePropertyDescriptor(this, deployedPropertyDescriptor);
            if (withDefaults) {
                GlobalContextRegistry.register(generatedDeployablePropertyDescriptor, GlobalContextRegistry.lookup(deployedPropertyDescriptor));
            }
            addPropertyDescriptor(generatedDeployablePropertyDescriptor);
        }
    }

    @Override
    protected IDescriptorRegistry descriptorRegistry() {
        return deployedDescriptor.descriptorRegistry();
    }
}
