package com.xebialabs.deployit.booter.local;

import java.util.Optional;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.xlplatform.synthetic.MethodSpecification;
import com.xebialabs.xlplatform.synthetic.PropertySpecification;

public class GeneratedParameterLocalDescriptor extends LocalDescriptor {

    public GeneratedParameterLocalDescriptor(Type type, MethodSpecification methodSpecification) {
        setType(type);
        initParameters(methodSpecification);
        initHierarchy();
        resolveIcon();
    }

    private void initParameters(MethodSpecification methodSpecification) {
        addSuperClass(typeOf(Parameters.class));
        String name = methodSpecification.getName();
        setDescription("Generated type for method " + name + ".");
        setRootName(Optional.empty());
        for (PropertySpecification parameter : methodSpecification.getParameters()) {
            LocalPropertyDescriptor propDesc = new SyntheticLocalPropertyDescriptor(this, parameter);
            addPropertyDescriptor(propDesc);
        }
    }

    @Override
    protected IDescriptorRegistry descriptorRegistry() {
        return DescriptorRegistry.getDescriptorRegistry(getType().getTypeSource());
    }
}
