package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

import static java.lang.String.format;

public class Verifications {
    private List<String> verifications = new ArrayList<>();

    public Verifications() {
    }

    void verify(Type t, boolean condition, String messageTemplate, Object... parameters) {
        if (!condition) {
            verifications.add(t + ": " + format(messageTemplate, parameters));
        }
    }

    void verify(boolean condition, String messageTemplate, Object... parameters) {
        if (!condition) {
            verifications.add(format(messageTemplate, parameters));
        }
    }

    public void done() {
        if (!verifications.isEmpty()) {
            logger.error("Verifications failed:");
            for (String s : verifications) {
                logger.error(s);
            }
            throw new IllegalStateException("There is an error in the defined types: \n" + String.join("\n", verifications));
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(LocalBooter.class);
}
