package com.xebialabs.xlplatform.synthetic.yaml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import com.fasterxml.jackson.databind.JsonNode;

import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.synthetic.*;

import static java.util.Collections.emptyList;

public class JsonTypeSpecification extends JsonSpecification implements TypeSpecification {

    private static final String DEFAULT_BASE_TYPE_NAME = "udm.BaseConfigurationItem";

    public JsonTypeSpecification(IDescriptorRegistry descriptorRegistry, String name, JsonNode node) {
        super(descriptorRegistry, name, node);
    }

    @Override
    public Type getType() {
        return descriptorRegistry().lookupType(name);
    }

    @Override
    public Optional<Boolean> getVirtual() {
        return getOptionalBoolean("virtual");
    }

    @Override
    public List<PropertySpecification> getProperties() {

        // properties
        List<PropertySpecification> properties = new ArrayList<>(getProperties("properties"));

        // hidden-properties
        List<JsonPropertySpecification> hiddenProperties = getProperties("hidden-properties");
        hiddenProperties.forEach(p -> p.defaultHidden = true);
        properties.addAll(hiddenProperties);

        // input-properties
        List<JsonPropertySpecification> inputProperties = getProperties("input-properties");
        inputProperties.forEach(p -> p.defaultCategory = "input");
        properties.addAll(inputProperties);

        // output-properties
        List<JsonPropertySpecification> outputProperties = getProperties("output-properties");
        outputProperties.forEach(p -> p.defaultCategory = "output");
        properties.addAll(outputProperties);

        return properties;
    }

    @Override
    public Optional<Boolean> getVersioned() {
        return getOptionalBoolean("versioned");
    }

    @Override
    public Type getSuperType() {
        return getOptionalType("extends").orElse(descriptorRegistry().lookupType(DEFAULT_BASE_TYPE_NAME));
    }

    @Override
    public Optional<Boolean> getInspectable() {
        return getOptionalBoolean("inspectable");
    }

    @Override
    public Optional<String> getIcon() {
        return getOptionalString("icon");
    }

    @Override
    public Optional<String> getRoot() {
        return getOptionalString("root");
    }

    @Override
    public Optional<Type> getDeployedType() {
        return getOptionalType("deployable-type");
    }

    @Override
    public Optional<Type> getContainerType() {
        return getOptionalType("deployed-type");
    }

    @Override
    public List<MethodSpecification> getMethods() {
        List<MethodSpecification> methods = new ArrayList<>();
        if (!node.has("methods")) {
            return methods;
        }

        JsonNode methodNodes = node.get("methods");
        Iterator<String> iter = methodNodes.fieldNames();
        while (iter.hasNext()) {
            String methodName = iter.next();
            methods.add(new JsonMethodSpecification(descriptorRegistry(), methodName, methodNodes.get(methodName)));
        }

        return methods;
    }

    @Override
    public List<MethodSpecification> getControlTasks() {
        // XXX What is the difference between methods and control tasks?
        return getMethods();
    }

    // Deploy-specific functionality
    // XXX Currently not supported

    // TODO Implement
    @Override
    public List<String> getVerifications() {
        return emptyList();
    }

    // TODO Implement
    @Override
    public boolean hasGenerateDeployable() {
        return false;
    }

    // TODO Implement
    @Override
    public TypeSpecification getGenerateDeployable() {
        return null;
    }

    // TODO Implement
    @Override
    public GeneratedDeployableSpecification getGeneratedDeployableDescription() {
        return null;
    }

    // TODO Implement
    @Override
    public Optional<CreatorSpecification> getCreator() {
        return Optional.empty();
    }
}
