package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.xlplatform.synthetic.BaseTypeSpecification;
import com.xebialabs.xlplatform.synthetic.MethodSpecification;

public class GeneratedParameterTypeDefinition extends TypeDefinition {

    private final MethodSpecification methodSpecification;

    public GeneratedParameterTypeDefinition(IDescriptorRegistry descriptorRegistry, BaseTypeSpecification owner, MethodSpecification methodSpecification) {
        this.owner = owner.getType();
        this.methodSpecification = methodSpecification;
        this.type = generatedParameterType(descriptorRegistry, owner.getType(), methodSpecification.getName());
        this.superType = descriptorRegistry.lookupType(Parameters.class);
    }

    private Type generatedParameterType(final IDescriptorRegistry registry, final Type type, final String name) {
        Type baseType = registry.lookupType(type.toString());
        return registry.lookupType(baseType.toString() + "_" + name);
    }

    @Override
    protected LocalDescriptor createDescriptor() {
        return new GeneratedParameterLocalDescriptor(this.type, methodSpecification);
    }
}
