package com.xebialabs.deployit.booter.local;

import java.util.*;
import java.util.stream.Collectors;

import com.xebialabs.deployit.plugin.api.reflect.ConfigurationItemPostConstructor;
import com.xebialabs.deployit.plugin.api.reflect.Process;
import com.xebialabs.deployit.plugin.api.reflect.Type;

import nl.javadude.scannit.Scannit;

import static java.util.stream.Stream.concat;
import static java.util.stream.Stream.of;

final class ConfigurationItemPostProcessors {

    private static final Map<Type, List<ConfigurationItemPostConstructor>> processorsPerType = new HashMap<>();

    private ConfigurationItemPostProcessors() {
    }

    static void registerPostProcessors() {
        Set<Class<?>> processors = new HashSet<>();
        Scannit scannit = Scannit.getInstance();
        processors.addAll(scannit.getTypesAnnotatedWith(Process.class));
        processors.retainAll(scannit.getSubTypesOf(ConfigurationItemPostConstructor.class));
        processors.forEach(ConfigurationItemPostProcessors::registerPostProcessor);
    }

    static Set<ConfigurationItemPostConstructor> getProcessors(Type type) {
        List<Type> superTypes = type.getDescriptor().getSuperClasses();
        Set<Type> interfaces = type.getDescriptor().getInterfaces();
        return concat(concat(of(type), superTypes.stream()), interfaces.stream()).flatMap(t -> processorsPerType.getOrDefault(t, Collections.emptyList()).stream()).collect(Collectors.toSet());
    }

    static private void registerPostProcessor(Class<?> postProcessorClass) {
        try {
            // TODO S-88045 post processors should be done for types in a specific registry
            String type = postProcessorClass.getAnnotation(Process.class).type();
            processorsPerType.computeIfAbsent(Type.valueOf(type), t -> new ArrayList<>()).add((ConfigurationItemPostConstructor) postProcessorClass.newInstance());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
